#include <Estatistica.h>


Hist *achaPos(Hist *h,int m,int v)
{
	Hist *aux=h;
	while ((aux!=NULL)&&(aux->I!=m)&&(aux->J!=v))
		aux=aux->prox;
	return aux;
}

void insereHist(Hist *h,int i,int j,int q)
{
	Hist *novo=malloc(sizeof(Hist));
	novo->I=i;
	novo->J=j;
	novo->Q=q;
	novo->prox=NULL;
	if (h==NULL)
		h=novo;
	else
	{
		Hist *aux=h;
		Hist *ant=NULL;
		while ((aux!=NULL)&&(aux->I<i))
		{
			ant=aux;
			aux=aux->prox;
		}
		if (aux==NULL)
			aux->prox=novo;
		else
		{
			ant->prox=novo;
        		novo->prox=aux;
		}
	}
}

void calculaHist(Hist *h,float_image_t *Md,float_image_t *Sd)
{
	int i,j,x,y;
	int c=Md->sz[0]-1;
	float media=0, variancia=0;
	Hist *pos=NULL;
	for (x=0;x<Md->sz[1];x++)
	{
		for (y=0;y<Md->sz[2];y++)
		{
			media=float_image_get_sample(Md,c,x,y);
			variancia=float_image_get_sample(Sd,c,x,y);
			i=(int)(media);
			j=(int)(variancia);
			pos=achaPos(h,i,j);
			if (pos==NULL)
				insereHist(h,i,j,1);
			else
				pos->Q=pos->Q+1;
		}
	}
}

void free_Hist(Hist *list)
{
   Hist *aux;
   while (list!=NULL)
   {
      aux=list;
      list=list->prox;
      free(aux);
   }
}

void gravaHist(Hist *h,char *dir,char *tipo,char *name,int res)
{
	char *filename=NULL;
	asprintf(&filename,"%s/%s/%s_R%02d.txt",dir,tipo,name,res);
	FILE *f=fopen(filename,"w");
        if (f == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", filename); assert(0); }
	while (h!=NULL)
	{
		fprintf(f,"%d %d %d",h->I,h->J,h->Q);
		h=h->prox;
	}
	fclose(f);
	free(filename);
}

/*void carregaImagens(char *nameDir,int res)
{
	int i;
	char *file=NULL;
	for (i=0;i<res;i++)
	{
		asprintf(&file,"%s/%s/R%02dlumi.ppm",nameDir,"Md",i);
		float_image_t *Md=getImageOpenRGB(file);
		asprintf(&file,"%s/%s/R%02dlumi.ppm",nameDir,"Sd",i);
		float_image_t *Sd=getImageOpenRGB(name);
		float_image_free(Md);
		float_image_free(Sd);
	}
}*/

/*int main(int argc, char** argv)
{
   	char *nameDir = argv[1]; 
   	char *nameArq = argv[2];
   	int r = atoi(argv[3]);
   
	Hist *h=NULL;

	//calculaHist(h,Md,Sd);
	//gravaHist(h,dir,tipo,name,res);
	free_Hist(h);
	
	return 0;
}*/
