#define _GNU_SOURCE
#include <Graph.h>
#include <string.h>
#include <operacoes.h>

//INTERNAS

Vertice *novoVertice(int indice,int x,int y,Vizinho *vizinho,Vizinho *vizinhoD,Vertice *azul);

Vizinho *novoVizinho(Vertice *v);

void insere_Pixels(Grafo *grafo,Vertice *v);

void gera_lista_Pixels(Grafo *grafo,float_image_t *img,int *indice);

Vertice *buscaVertice(Vertice *ini,int x,int y);

Vertice *insereVizinho(Vertice *v,Vertice *vizinho);

Vertice *insereVizinhoD(Vertice *v,Vertice *vizinho);

void gera_Rede_Nivel_K(Grafo *grafo,float_image_t *img,int indice,int diagonal);

Grafo unirGrafos(Grafo grafoA,Grafo grafoB);

Vertice *buscaIndice(Vertice *v, int indice);

void insereAzul(Vertice *v,int indice);

void ligarNiveis(Grafo *grafo,int N,int grupo,int w,int h);

Grafo cloneGrafo(Grafo grafo);

void exibeGrafo(Grafo grafo);

Grafo geraGrafoImagens(char *bandir,char *nome,int res_max,char *ext,char *tipo);


//IMPLEMENTAÇÕES

Vertice *novoVertice(int indice,int x,int y,Vizinho *vizinho,Vizinho *vizinhoD,Vertice *azul)
{
	Vertice *novo=malloc(sizeof(Vertice));
	novo->indice=indice;
	novo->x=x;
	novo->y=y;
	novo->vizinho=vizinho;
	novo->vizinhoD=vizinhoD;
	novo->azul=azul;
	novo->prox=NULL;
	return novo;
}

Vizinho *novoVizinho(Vertice *v)
{
	Vizinho *novo=malloc(sizeof(Vizinho));
	novo->vizinhos=v;
	novo->prox=NULL;
	return novo;
}

void insere_Pixels(Grafo *grafo,Vertice *v)
{
	if ((*grafo).ini==NULL)
	{
		(*grafo).ini=v;
		(*grafo).fim=v;
	}
	else
	{
		(*grafo).fim->prox=v;
		(*grafo).fim=v;
	}
}

void gera_lista_Pixels(Grafo *grafo,float_image_t *img,int *indice)
{
	int i,j;
	Vertice *pixel=NULL;
	for (i=0;i<img->sz[1];i++)
		for (j=0;j<img->sz[2];j++)
		{
			indice++;
			pixel=novoVertice(*indice,i,j,NULL,NULL,NULL);
			insere_Pixels(&(*grafo),pixel);
		}
}

Vertice *buscaVertice(Vertice *ini,int x,int y)
{
	Vertice *aux=ini;
	while ((aux!=NULL)&&(aux->x!=x)&&(aux->y!=y))
		aux=aux->prox;
	return aux;
}

Vertice *insereVizinho(Vertice *v,Vertice *vizinho)
{
	Vizinho *novo=novoVizinho(vizinho);
	if (v->vizinho==NULL)
		v->vizinho=novo;
	else
	{
		Vizinho *aux=v->vizinho;
		while (aux->prox!=NULL)
			aux=aux->prox;
		aux->prox=novo;
	}
	return v;
}

Vertice *insereVizinhoD(Vertice *v,Vertice *vizinho)
{
	Vizinho *novo=novoVizinho(vizinho);
	if (v->vizinhoD==NULL)
		v->vizinhoD=novo;
	else
	{
		Vizinho *aux=v->vizinhoD;
		while (aux->prox!=NULL)
			aux=aux->prox;
		aux->prox=novo;
	}
	return v;
}



void gera_Rede_Nivel_K(Grafo *grafo,float_image_t *img,int indice,int diagonal)
{
	int i,j;
	Vertice *v=(*grafo).ini;
	Vertice *vizinho;
	for (i=0;i<img->sz[1];i++)
		for (j=0;j<img->sz[2];j++)
		{
			vizinho=buscaVertice((*grafo).ini,i+1,j);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice((*grafo).ini,i-1,j);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice((*grafo).ini,i,j+1);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice((*grafo).ini,i,j-1);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			if (diagonal==1)
			{
				vizinho=buscaVertice((*grafo).ini,i+1,j-1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice((*grafo).ini,i+1,j+1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice((*grafo).ini,i-1,j-1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice((*grafo).ini,i-1,j+1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
			}
			v=v->prox;
		}
}

Grafo unirGrafos(Grafo grafoA,Grafo grafoB)
{
	grafoA.fim->prox=grafoB.ini;
	grafoA.fim=grafoB.fim;
	return grafoA;
}

Vertice *buscaIndice(Vertice *v, int indice)
{
	Vertice *aux=v;
	while ((aux!=NULL)&&(aux->indice!=indice))
		aux=aux->prox;
	return aux;
}

void insereAzul(Vertice *v,int indice)
{
	Vertice *ant=NULL;
	ant=buscaIndice(v,indice);
	if (ant!=NULL)
		ant->azul=v;
}

void ligarNiveis(Grafo *grafo,int N,int grupo,int w,int h)
{
	Vertice *v=(*grafo).ini;
	int tam=w*h;
	int K=0,i=0,j;
	while (K<N)
	{
		while (i<=tam)
		{
			for (j=0;j<=grupo;j++)
			{
				insereAzul(v,(2*v->indice+i));
				insereAzul(v,(2*v->indice+i+w));
			}
			i++;
			v=v->prox;
		}
		tam=tam+grupo*tam;
		w=grupo*w;
		K++;
	}
}

Grafo cloneGrafo(Grafo grafo)
{
	Grafo newG;
	newG.ini=NULL;
	newG.fim=NULL;
	Vertice *aux=NULL;
	aux=grafo.ini;
	while (aux!=NULL)
	{
		insere_Pixels(&newG,novoVertice(aux->indice,aux->x,aux->y,aux->vizinho,aux->vizinhoD,aux->azul));
		aux=aux->prox;
	}
	return newG;
}

void exibeGrafo(Grafo grafo)
{
	Vertice *v=grafo.ini;
	Vizinho *vz=NULL;
	while (v!=NULL)
	{
		fprintf(stderr, "%d:",v->indice);
		vz=v->vizinho;
		while (vz!=NULL)
		{
			fprintf(stderr, " ->%d",(vz->vizinhos)->indice);
			vz=vz->prox;
		}
		fprintf(stderr, "\n-->%d\n",(v->azul)->indice);
		v=v->prox;
	}
}

Grafo geraGrafoImagens(char *bandir,char *nome,int res_max,char *ext,char *tipo)
{
	char *filename=NULL;
	int i;
	int indice=0;
	int w=0,h=0;
	int grupo=4;
	sign_t round_dir;

	Grafo listGrafo[res_max+1];

	for (i=0;i<res_max;i++)
	{
		asprintf(&filename,"%s/%s/%s/R%02d.%s",bandir,nome,tipo,i,ext);
		if ((strcmp(tipo,"Hi")==0)||(strcmp(tipo,"Sd")==0))
			round_dir=POS;
		else if (strcmp(tipo,"Lo")==0)
			round_dir=NEG;
		else
			round_dir=ZER;
		float_image_t *img=getImageOpenRGB(filename,round_dir);
                if (i==0)
		{
                	w=img->sz[1];
			h=img->sz[2];
		}
		gera_lista_Pixels(&listGrafo[i],img,&indice);
		gera_Rede_Nivel_K(&listGrafo[i],img,indice,0);
		float_image_free(img);
	}
	
	Grafo grafo=listGrafo[0];
	for (i=1;i<res_max;i++)
	{
		grafo=unirGrafos(grafo,listGrafo[i]);
	}
	ligarNiveis(&grafo,res_max,grupo,w,h);
	exibeGrafo(grafo);
        return grafo;
}
