#define _GNU_SOURCE
#include <stdio.h>

#include <escalaImagem.h>

float_image_t *getImageOpenRGB(char *name)
{
   if (strlen(name)>=1)
   {
      FILE *arq;
      arq = fopen(name,"rw");
      float_image_t *I = ex_read_image(arq, name);
      fclose(arq);
      return I;
   }
   return NULL;
}

//funções para identificação do objeto na imagem


//identifica o quadro onde o objeto esta contido
void determinaQuadro(float_image_t *J,int quadro[4],double brilhofundo)
{
   int x,y;
   int nx=J->sz[1],ny=J->sz[2];
   int xmin=nx,xmax=0,ymin=ny,ymax=0;
   double valor=0.0;
   float R=0,G=0,B=0;
//encontra ymin e ymax
   for (x=0;x<nx;x++)
   {
      for (y=0;y<ny;y++)
      {
         R=float_image_get_sample(J,0,x,y);
         G=float_image_get_sample(J,1,x,y);
         B=float_image_get_sample(J,2,x,y);
         valor=calculaBrilho(R,G,B);

         if (valor>brilhofundo)
         {
           if (y<ymin){ ymin=y; }
           if (y>ymax){ ymax=y; }
         }
      }
   }
   for (y=0;y<ny;y++)
   {
      for (x=0;x<nx;x++)
      {
         R=float_image_get_sample(J,0,x,y);
         G=float_image_get_sample(J,1,x,y);
         B=float_image_get_sample(J,2,x,y);
         valor=calculaBrilho(R,G,B);

         if (valor>brilhofundo)
         {
           if (x<xmin){ xmin=x; }
           if (x>xmax){ xmax=x; }
         }
      }
   }
   quadro[0]=xmin; quadro[1]=xmax; quadro[2]=ymin; quadro[3]=ymax;
}


//identifica o quadro onde esta o objeto na imagem
void defineQuadro(image_brilho *list,int quadro[4],int pos)
{
   int i=0;
   int xmin=999999,xmax=0,ymin=999999,ymax=0;
   double brilho=0;

   while ((list!=NULL)&&(i<=pos))
   {
       brilho=list->brilho;
       list=list->prox;
       i++;
   }

   while (list!=NULL)
   {
      if (list->brilho>brilho)
      {
         if (ymin>=list->y)
            ymin=list->y;
         if (ymax<=list->y)
            ymax=list->y;
         if (xmin>=list->x)
            xmin=list->x;
         if (xmax<=list->x)
            xmax=list->x;
      }
      list=list->prox;
   }
   quadro[0]=xmin; quadro[1]=xmax; quadro[2]=ymin; quadro[3]=ymax;
}

//tamanho da região a cortar
void tamanhoCorte(int w[2],int quadro[4],int nx,int ny)
{
   float A=(quadro[1]-quadro[0]+1)/nx,B=(quadro[4]-quadro[3]+1)/ny;
   float S=A;
   if (S>B)
      S=B;
   w[0]=(int)(ceil(nx*S));
   w[1]=(int)(ceil(ny*S));
}

//identifica os cantos do quadro para realizar o corte
void cantoCorte(int d[2],int w[2],int cx,int cy,int nx,int ny)
{
   d[0]=(int)(cx-(w[0]/2));
   d[1]=(int)(cy-(w[1]/2));
   if (d[0]<0)
      d[0]=0;
   else if ((d[0]+w[0])>nx)
      d[0]=nx;
   if (d[1]<0)
      d[1]=0;
   else if ((d[1]+w[1])>ny)
      d[1]=ny;
}

//adapta o quadro a sua posição na imagem nova
char *escalaQuadroImagem(float_image_t *img,char *nome,int quadro[4])
{
   double cx=0.0,cy=0.0;
   int w[2],d[2];
   int nx=img->sz[1],ny=img->sz[2];

   if (quadro[0]>0)
      quadro[0]--;
   if (quadro[1]<img->sz[1])
      quadro[1]++;
   if (quadro[2]>0)
      quadro[2]--;
   if (quadro[3]<img->sz[2])
      quadro[3]++;
   //define o centro do quadro
   cx=(quadro[1]-quadro[0])/2;
   cy=(quadro[3]-quadro[2])/2;
   //tamanho da região a cortar
   tamanhoCorte(w,quadro,nx,ny);
   //posição dos cantos a cortar da região
   cantoCorte(d,w,cx,cy,nx,ny);

   char *linha=NULL;
   asprintf(&linha,"convert %s.ppm -crop '%dx%d+%d+%d' -resize '%dx%d' %s-c.ppm\n",nome,w[0],w[1],d[0],d[1],nx,ny,nome);
   return linha;
}

//fim funções definição objeto na imagem


void exibeBrilhoImagem(image_brilho *l)
{
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   while (l!=NULL)
   {
      fprintf(stderr, "Brilho: %8.6f, X: %d, Y: %d\n",l->brilho,l->x,l->y);
      l=l->prox;
   }
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
}


void escala(char *filename,float percent)
{
   int quadro[4];
   int pos=0;
   double brilho_=0.0;
   char *linha=NULL;
   FILE *arq=fopen("convert_images.txt","a+");
   image_brilho *l=NULL;
   float_image_t *I=getImageOpenRGB(filename);
   l=calculaListaBrilho(l,I);
   pos=(int)(I->sz[1]*I->sz[2]*percent);
   //exibeBrilhoImagem(l);
   brilho_=retornaBrilhoPos(l,pos);
   determinaQuadro(I,quadro,brilho_);

   // linha=escalaQuadroImagem(I,filename,quadro);

   //fputs(linha,arq);

   fprintf(stderr, "\nxmin: %d, xmax: %d, ymin: %d, ymax: %d\n",quadro[0],quadro[1],quadro[2],quadro[3]);
   free_ListaBrilho(l);
   float_image_free(I);
   free(linha);

   fclose(arq);
}

int main(int argc, char** argv)
{

  void *trash = malloc(1);
  struct mallinfo info;
  int MemDinInicial, MemDinFinal;
  free(trash);
  info = mallinfo();
  MemDinInicial = info.uordblks;

  //começa aqui

  if(argc != 4)
  {
     fprintf(stderr, "Falta-se argumentos para o programa %s\n", argv[0]);
     return 1;
  }

  escala(argv[1],0.2);

  //termina aqui

  info = mallinfo();
  MemDinFinal = info.uordblks;
  if (MemDinInicial!=MemDinFinal)
    fprintf(stderr, "\n\nMain loop: Dinamic memory was not completely deallocated (%d, %d)\n", MemDinInicial,MemDinFinal);

  return 1;
}


float_image_t *ex_read_image(FILE *rd, char *name)
  { bool_t close_it = FALSE;
    if (rd == NULL) { rd = open_read(name, TRUE); close_it = TRUE; }
    pnm_image_t *pim = pnm_image_fread(rd);
    float_image_t *fim = float_image_from_pnm_image(pim, NULL, NULL, FALSE);
    pnm_image_free(pim);
    if (close_it) { fclose(rd); }
    return fim;
  }

/*
void escalaImagens(int ini,int fim)
//void escalaImagens(int fim,float percent)
{
   int ini=0,fim=0, muda=0;
   int i=0,quadro[4];
   int pos=0;
   double brilho_=0.0;
   char *nomearquivo=NULL;
   if (muda==0)
   {
      ini=param[0]; fim=param[1];
      muda++;
   }
   else
   {
      ini=param[1]; fim=param[2];
   }
   asprintf(&nomearquivo,"convert_images_%d.txt",ini);
   //FILE *arq=fopen(nomearquivo,"a+");
   free(nomearquivo);
   image_brilho *l;
   for (i=ini;i<fim;i++)
   {
      char *filename=NULL;
      char *name=NULL;
      char *linha=NULL;
      asprintf(&filename,"../Imagens/img%03d.ppm",i);
      float_image_t *I=getImageOpenRGB(filename);
      asprintf(&name,"img%03d",i);
      l=NULL;
      l=calculaListaBrilho(l,I);
      pos=(int)(I->sz[1]*I->sz[2]*percent);
//exibeBrilhoImagem(l);
      brilho_=retornaBrilhoPos(l,pos);
      determinaQuadro(I,quadro,brilho_);

     // linha=escalaQuadroImagem(I,name,quadro);

      //fputs(linha,arq);

      fprintf(stderr, "\nxmin: %d, xmax: %d, ymin: %d, ymax: %d\n",quadro[0],quadro[1],quadro[2],quadro[3]);
      free_ListaBrilho(l);
      float_image_free(I);
      free(filename);
      free(name);
      free(linha);
   }
   //fclose(arq);
   //pthread_exit(NULL);
   return NULL;
}
*/
