/* Routines for standard interval arithmetic    */
/* Last edited on 2009-11-23 01:12 by ceaz */

#ifndef ia_H
#define ia_H

#include <flt.h>
#include <stdio.h>
#include <math.h>

typedef struct {Float lo, hi; } Interval;

void ia_init (void);
  /* Initializes the constants (ia_full, etc.) */
  /* MUST be called at least once before any of the routines below. */

Interval ia_full (void); /* The "anything" interval, [-Inf .. +Inf] */

int ia_is_full (Interval *x); 
  /* True iff {*x.lo} is -Inf or {*x.hi} is +Inf */

Interval ia_add   (Interval x, Interval y);
Interval ia_sub   (Interval x, Interval y);
Interval ia_neg   (Interval x);
Interval ia_scale (Interval x, Float alpha, Float zeta); /* {alpha * x / zeta} */
Interval ia_shift (Interval x, Float gamma);  /* {x + gamma} */
Interval ia_mul   (Interval x, Interval y);
Interval ia_div   (Interval x, Interval y);
Interval ia_sqrt  (Interval x);
Interval ia_abs   (Interval x);
Interval ia_max   (Interval x, Interval y);
Interval ia_min   (Interval x, Interval y);
Interval ia_pow   (Interval x, double e); /* {abs(x)^e} */
Interval ia_big   (Interval x, Interval y);
Float ia_mean     (Interval x);

Float ia_mid (Interval x);
  /* Approximate midpoint of {x}, guaranteed to be in {x}.
    Finite as long as {x} is finite. */

#endif
