

float_image_t *getImageEscaladaRGB(float_image_t *J,float vari[3]);


//escala os pixels da imagem para o domínio 0..1
float_image_t *getImageEscaladaRGB(float_image_t *I,float vari[])
{
  int i=0,j=0,c;   
  float valor=0;
      
  for (i=0;i<I->sz[1];i++)
    for (j=0;j<I->sz[2];j++)
      {         
	for (c=0; c < I->sz[0]; c++)
	  { 
	    valor=float_image_get_sample(I,c,i,j);         
	    valor=(valor*0.998047)/vari[c];
	    float_image_set_sample(I,c,i,j,(valor));
	  }
      }
  return I;
}

/*//remove da lista as imagens que apresentam diastância maior que Hi
image_ref *avaliaDistanciasRGB(image_ref *list,float Hi)
{
   image_ref *aux;

   aux=list;
   while (aux!=NULL)
   {
      if (aux->distLo>Hi)
         list=removeImage(list,aux);
      aux=aux->prox;
   }
   return list;
}*/

/*
float dLoRGB(float aLo,float aHi,float bLo,float bHi)
{
   float valor=-1;
   if ((aLo<=bHi)&&(aHi>=bLo))
      valor=0.0;
   else if (aLo>bHi)
      valor=fabs(aLo-bHi);
   else if (aHi<bLo)
      valor=fabs(aHi-bLo);
   return valor;
}

float dHiRGB(float aLo,float aHi,float bLo,float bHi)
{
   float valor=aHi-bLo;
   if (valor<(bHi-aLo))
      valor=bHi-aLo;
   return valor;
}

*/


//funções do arquivo
//float_image_t *calculaMedia(float_image_t *I,int k);
/*float_image_t *calculaVariancia(float_image_t *I,float_image_t *J,int k);
float_image_t *calculaIntervaloLo(float_image_t *I,int k,float intervalo);
float_image_t *calculaIntervaloHi(float_image_t *I,int k,float intervalo);*/

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//Média Aritmética da Região
/*void getMediaRegiaoRGB(float_image_t *I,float v[3],int inil,int fiml,int inic,int fimc)
{
  int i=0,j=0;
  float somaR=0,somaG=0,somaB=0;
  for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
         somaR+=float_image_get_sample(I,0,i,j);
         somaG+=float_image_get_sample(I,1,i,j);
         somaB+=float_image_get_sample(I,2,i,j);
     }
  i=(fiml-inil)*(fimc-inic);
  v[0]=somaR/(i);
  v[1]=somaG/(i);
  v[2]=somaB/(i);
}*/

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
//nova seleção considerando os diversos níveis juntos
image_ref *selecaoImagemOrdenadasRGB
  ( char *bandir,
    int num,
    int res_max,
    int fator,
    char *model_name,
    int vet[] )
  {
   image_ref *list;
   int res;
   for (res = 0; res < res_max; res++) { vet[res] = 0; }
   vet[res_max] = num-1;
   list=criaListaOrdenadaRGB(bandir,num,model_name);
   float distMax=menorDistHi(list);
   list=removeImagensMaioresDist(list,distMax);
   fprintf(stderr, "\n\n\n\n\n");

   int num_resultados = 0;
   int num_resultados_desejados = 5;
   int cont=0;

   char *res_filename=NULL;
   asprintf(&res_filename,"%s/%s/resultados.txt",bandir,model_name);
   FILE *arq = fopen(res_filename,"w");
   fprintf(arq,"#Resultados\n");
   fprintf(arq,"#Nome  DistMin  DistMax  Resolução\n");

   while (list!=NULL)
   {
      //Gera um arquivo com as informações atuais
      drawList(list,bandir,model_name,list->distLo,distMax,num,cont);
      cont++;

      if ((list->distLo==list->distHi)||(list->resolucao==0))
      {
          escreveResultado(arq,list);
          num_resultados++;
          list=removeImage(list,list);
          if (num_resultados>=num_resultados_desejados)
             break;
      }
      else
      {
         int res=list->resolucao-1;
         char *bname=list->name;

         float_image_t *Alo=leImagemTipoEscala(bandir,"Lo",res,model_name);
         float_image_t *Ahi=leImagemTipoEscala(bandir,"Hi",res,model_name);

         float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,bname);
         float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,bname);
	
	 float oldLo=list->distLo;
	 float oldHi=list->distHi;
         list=removeImage(list,list);

	 float distlo=distLoRGB(Alo,Ahi,Blo,Bhi);
         float disthi=distHiRGB(Alo,Ahi,Blo,Bhi);
	 assert(oldLo<=distlo);
	 assert(oldHi>=disthi);
         vet[res]++;
         fprintf(stderr, "Imagem  %s %02d  %8.6f  %8.6f refinada\n",bname,res,distlo,disthi);

         list=insertSortImage(list,distlo,disthi,bname,res);

         float_image_free(Alo);
         float_image_free(Ahi);
         float_image_free(Blo);
         float_image_free(Bhi);
         if (disthi<distMax)
         {
		

            distMax=disthi;
            list=removeImagensMaioresDist(list,distMax);	    
         }
      }
   }
   fputs("\n#Imagens Restantantes\n",arq);
   escreveListaResultados(arq,list);
   fputs("\n\n#Fim dos Resultados\n",arq);
   fclose(arq);
   return list;
}*/

/*	while (list!=NULL)
	{
		//Gera um arquivo com as informações atuais
		drawList(list,bandir,model_name,list->distLo,distMax,num,cont);
		cont++;

		if ((list->distLo==list->distHi)||(list->resolucao==0))
		{
			escreveResultado(arq,list);
			num_resultados++;
			list=removeImage(list,list);
			if (num_resultados>=num_resultados_desejados)
				break;
		}
		else
		{
			int res=list->resolucao-1;
			char *bname=list->name;

			float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,bname);
			float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,bname);
	
			float oldLo=list->distLo;
			float oldHi=list->distHi;
			list=removeImage(list,list);

			float distlo=distLoRGB(modeloLo[res],modeloHi[res],Blo,Bhi);
			float disthi=distHiRGB(modeloLo[res],modeloHi[res],Blo,Bhi);
			assert(oldLo<=distlo);
			assert(oldHi>=disthi);
			vet[res]++;
			fprintf(stderr, "Imagem  %s %02d  %8.6f  %8.6f refinada\n",bname,res,distlo,disthi);

			list=insertSortImage(list,distlo,disthi,bname,res);

			float_image_free(Blo);
			float_image_free(Bhi);

			if (disthi<distMax)
			{
				distMax=disthi;
				list=removeImagensMaioresDist(list,distMax);	    
			}
		}
	}*/


----------------------------------------------------------------------
int insereHi(filaCandidatos *fila,candidato_t *c)
{
	int i;
	int max=fila->mH-1;
	if (fila->mH>fila->n)
	{
		max=fila->n-1;
	}
	else
	{
		if (c->distHi>fila->H[max-1].distHi)
			return False;
	}

	for (i=max;i>0;i--)
	{
		if (c->distHi>fila->H[i-1].distHi)
		{
			fila->L[i]=*c;
			return True;
		}
		fila->H[i]=fila->H[i-1];
	}
	fila->H[i]=*c;
	return True;
}

int insereLo(filaCandidatos *fila,candidato_t *c)
{
	int i;
	int max=fila->mL-1;
	if (fila->mL>fila->n)
	{
		max=fila->n-1;
	}
	else
	{
		if (c->distLo>fila->L[max-1].distLo)
			return False;
	}

	for (i=max;i>0;i--)
	{
		if (c->distLo>fila->L[i-1].distLo)
		{
			fila->L[i]=*c;
			return True;
		}
		fila->L[i]=fila->L[i-1];
	}
	fila->L[i]=*c;
	return True;
}

candidato_t *substitutoHi(filaCandidatos fila,candidato_t *c)
{
	candidato_t *aux=fila.cand;
	candidato_t *menor=aux;
	while (aux!=NULL)
	{
		if ((aux->distHi>=c->distHi)&&(menor->distHi>aux->distHi))
			menor=aux;
		aux=aux->prox;
	}
	return aux;
}

candidato_t *substitutoLo(filaCandidatos fila,candidato_t *c)
{
	candidato_t *aux=fila.cand;
	candidato_t *menor=aux;
	while (aux!=NULL)
	{
		if ((aux->distLo>=c->distLo)&&(menor->distLo>aux->distLo))
			menor=aux;
		aux=aux->prox;
	}
	return aux;
}

void remaneja(candidato_t *vet,int pos,int tam)
{
	if (pos<tam)
	{
		int i;
		for (i=pos;i<tam;i++)
			vet[i]=vet[i+1];
	}
}

int buscaCandidatoVet(candidato_t *vet,char *nome,int tam)
{
	int i;
	for (i=0;i<tam;i++)
	{
		if (strcmp(vet[i].nome,nome)==0)
			return i;
	}
	return -1;
}

----------------------------------------------------------------------


Plot_t *openFiles(Plot_t *plot,candidato_t *list,int nBoxes,char *dir,char *name)
{
  candidato_t *aux = NULL;
  aux=list;
  plot=new(aux->distLo,aux->distHi);
  Plot_t *novo=plot;
  aux=aux->prox;
  int cont=0;
  while ((aux!=NULL)&&(cont<nBoxes))
    {
      novo->prox=new(aux->distLo,aux->distHi);
      aux=aux->prox;
      novo=novo->prox;
      cont++;
    }
  makeDir(dir,name,"rectangles");
  makeDir(dir,name,"line_dmin");
  makeDir(dir,name,"line_dmax");
  return plot;
}

----------------------------------------------------------------------

//retira da lista as imagens em que a distância distlo é maior que uma disthi estabelecida
image_ref *removeImagensMaioresDist(image_ref *list,float disthi)
{
  image_ref *aux,*aux2;
  aux=list->prox;
  while (aux!=NULL)
    {
      if ((aux->distLo)>disthi)
	{
          aux2=aux;
          fprintf(stderr, "  Imagem  %s %02d  %8.6f  %8.6f eliminada \n",aux->name,aux->resolucao,aux->distLo,aux->distHi);
          aux=aux->prox;
          list=removeImage(list,aux2);
	}
      else
	aux=aux->prox;
    }
  return list;
}


//identifica a menor distância disthi
float menorDistHi(image_ref *list)
{
  float distHiMin = 999999;
  while (list!=NULL)
    {
      if ((list->distHi) < distHiMin) distHiMin = list->distHi;
      list = list->prox;
    }
  return distHiMin;
}

void escreveResultado(FILE *arq,image_ref *aux)
{
  fprintf(arq,"%s  %02d  %8.6f  %8.6f\n",aux->name,aux->resolucao,aux->distLo,aux->distHi);
}

void escreveListaResultados(FILE *arq,image_ref *list)
{
  image_ref *aux=list;
  while (aux!=NULL)
    {
      escreveResultado(arq,aux);
      aux=aux->prox;
    }
}

----------------------------------------------------------------------

candidato_t *escolheCandidato(filaCandidatos_t fila,int tipo)
{
  candidato_t *aux=fila;
  candidato_t *melhor=NULL;
  if (tipo==0)
    {	
      int respHi=0,respLo=0;
      float media=0,media2=0;
      while (aux!=NULL)
	{
	  respHi=buscaCandidatoVet(fila.H,aux->nome,fila.mH);
	  respLo=buscaCandidatoVet(fila.L,aux->nome,fila.mL);

	  if ((respHi==-1)&&(respLo==-1))
	    {
	      if (melhor==NULL)
		melhor=aux;
	      else
		{
		  media=(aux->distLo+aux->distHi)/2;
		  media2=(melhor->distLo+melhor->distHi)/2;
		  if (media<=media2)
		    melhor=aux;
		}
	    }
	  aux=aux->prox;
	}
    }
  return melhor;
}

// versão anterior a mudança para testes com IA e MD_SD separados
float dLoMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd, int bgZero)
{
  if (bgZero)
    { if ((aLo==0)&&(bLo==0))
        { // Os dois tem fundo, e podem ser totalmente fundo: 
	  return 0; }
      else if ((aLo==0)&&(aHi==0))
        { // {A} é totalmente fundo e {B} nao tem nada de fundo: 
	  return DFUNDO; }
      else if ((bLo==0)&&(bHi==0))
        { // {B} é totalmente fundo e {A} nao tem nada de fundo: 
	  return DFUNDO; }
      else 
        { // Nenhum dos dois tem fundo - tratamento normal: 
        }
    }

  // Calcula um limite {dLo} usando aritmetica intervalar:
  float dLo;
  float xHi,yLo;
  if (aLo>bLo)
    { xHi=bHi; yLo=aLo; }
  else
    { xHi=aHi; yLo=bLo; }
   
  if (xHi>=yLo)
    dLo = 0;
  else if (aHi < bLo) 
    dLo = (bLo-aHi);
  else if (aLo > bHi)
    dLo = (aLo-bHi);

  if (USA_MD_SD && ((aLo < aHi) || (bLo < bHi)))
    { // Intervalo nao eh trivial -- tenta melhorar com media, desvio, arredondamento:
      // Ajusta {dLo} levando em conta media e desvio:
      float dLo1 = sqrt((aMd-bMd)*(aMd-bMd) + (aSd-bSd)*(aSd-bSd)); if (dLo < dLo1) { dLo = dLo1; }
      // Ajusta {dLo} para levar em conta erros de arredondamento:
      dLo -= 1.0e-6;
    }
  else
  // Ajusta {dLo} para nao sair do intervalo [0_1]:
  if (dLo < 0) { dLo = 0; }
  if (dLo > 1) { dLo = 1; }
  return dLo;
}

// versão anterior a mudança para testes com IA e MD_SD separados
float dHiMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd, int bgZero)
{
  if (bgZero)
    { if ((aLo==0)&&(aHi==0)&&(bLo==0)&&(bHi==0))
        { // Os dois sao totalmente fundo: 
          return 0; }
      else if ((aLo==0) || (bLo==0))
        { // Um deles pode ter fundo, e o outro pode ter nao-fundo: 
          return DFUNDO; }
      else 
        { // Nenhum dos dois tem fundo - tratamento normal:  
        }
    }

  // Calcula um limite {dHi} usando aritmetica intervalar:
  double dHi;
  double a = fabs(aHi-bLo);
  double b = fabs(bHi-aLo);
  if (a>b)
    dHi = a;
  else
    dHi = b;	

  if (USA_MD_SD && ((aLo < aHi) || (bLo < bHi)))
    { // Intervalo nao eh trivial -- tenta melhorar com media, desvio, arredondamento:
      // Ajusta {dHi} levando em conta media e desvio:
      float dHi1 = sqrt((aMd-bMd)*(aMd-bMd) + (aSd+bSd)*(aSd+bSd)); if (dHi > dHi1) { dHi = dHi1; }
      // Ajusta {dHi} para levar em conta erros de arredondamento:
      dHi += 1.0e-6;
   }

  // Ajusta {dHi} para nao sair do intervalo [0_1]:
  if (dHi < 0) { dHi = 0; }
  if (dHi > 1) { dHi = 1; }
  
  return dHi;
}

// versão anterior a mudança para testes com IA e MD_SD separados
float dMdMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd, int bgZero)
{
  if (bgZero)
    { if ((aLo==0)&&(aHi==0)&&(bLo==0)&&(bHi==0))
        { // Os dois sao totalmente fundo:
          return 0; }
      else if ((aHi==0) || (bHi==0))
        { // Um deles eh totalmente fundo, e o outro pode ter nao-fundo: 
          return DFUNDO; }
      else 
        { // Nenhum dos dois eh totalmente fundo - tratamento normal: 
        }
    }
  double dMd;
  if (USA_MD_SD)
    { double abMd = aMd-bMd;
      dMd = sqrt(aSd*aSd + bSd*bSd + abMd*abMd);
    }
  else
    { dMd = fabs((aHi+aLo)/2 - (bHi+bLo)/2); }

  // Ajusta {dMd} para nao sair do intervalo [0_1]:
  if (dMd < 0) { dMd = 0; }
  if (dMd > 1) { dMd = 1; }
  
  return dMd;
}

//cria lista com todas as imagens em nível 5 de redução e ordenadas pela distLo
image_ref *criaListaOrdenadaRGB(char *bandir,int num,char *model_name,char *ext,int bgZero,int usa_IA,int usa_MD_SD)
{
  image_ref *list = NULL;
   int i=0, resMax=5;
   float_image_t *Alo, *Ahi, *Amd, *Asd,*Blo, *Bhi,*Bmd, *Bsd;
   Alo=leImagemTipoEscala(bandir,"Lo",resMax,model_name,ext);
   Ahi=leImagemTipoEscala(bandir,"Hi",resMax,model_name,ext);
   Amd=leImagemTipoEscala(bandir,"Md",resMax,model_name,ext);
   Asd=leImagemTipoEscala(bandir,"Sd",resMax,model_name,ext);

   for (i=0;i<num;i++)
   {
      char *bname=NULL;
      asprintf(&bname,"%05d",i);
      Blo=leImagemTipoEscala(bandir,"Lo",resMax,bname,ext);
      Bhi=leImagemTipoEscala(bandir,"Hi",resMax,bname,ext);
      Bmd=leImagemTipoEscala(bandir,"Md",resMax,bname,ext);
      Bsd=leImagemTipoEscala(bandir,"Sd",resMax,bname,ext);
      if (strcmp(model_name, bname) != 0)
      {  float dist[3];
	 distRGB(Alo,Ahi,Amd,Asd,Blo,Bhi,Bmd,Bsd,bgZero,dist,usa_IA,usa_MD_SD);

         fprintf(stderr, "Imagem  %s %02d  %8.6f  %8.6f inserida\n", bname, resMax, dist[0],dist[1]);
         list=insertSortImage(list,dist[0],dist[1],bname,resMax);
      }
      float_image_free(Blo);
      float_image_free(Bhi);
      float_image_free(Bmd);
      float_image_free(Bsd);
      free(bname);
   }
   float_image_free(Alo);
   float_image_free(Ahi);
   float_image_free(Amd);
   float_image_free(Asd);
   return list;
}

void exibeMelhoresRGB(image_ref *list)
{
   image_ref *aux;
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   while (list!=NULL)
   {
      fprintf(stderr, "Nome: %s, DistLo: %4.4f, DistHi: %4.4f Res: %d\n",list->name,list->distLo,list->distHi,list->resolucao);
      aux=list;
      list=list->prox;
   }
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
}

void estima_dist_EURGB_MultiScale
(
    img_t *Alo, 
    img_t *Ahi,
    img_t *Amd,
    img_t *Asd, 
    img_t *Blo,
    img_t *Bhi,
    img_t *Bmd,
    img_t *Bsd,
    int res,
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float *distAcc,
    double lambda[],
    float dist[]
)
{
  // Calcula distância exata na escala {res} e acumula em {distAcc}:
  float dist_res = calcula_dist_EURGB(Amd,Bmd,bgZero);
fprintf(stderr, "-> %8.6f, %8.6f - ",dist_res,dist_res*lambda[res]);
  (*distAcc) += lambda[res]*dist_res;

  if (res > 0) {
    // Calcula estimativas da distância nas escalas {0..res-1} a partir das versões na escala {res}
    estima_dist_EURGB(Alo,Ahi,Amd,Asd,Blo,Bhi,Bmd,Bsd,res,res_max,bgZero,usa_IA,usa_MD_SD,dist);
  
    // Calcula peso total dessas estimativas:
    int k;
    float lambdaAcc=0.0;
    for (k=0;k<res;k++) { lambdaAcc += lambda[k]; }
fprintf(stderr, "[%8.6f  %8.6f] ~ %8.6f, ",dist[0],dist[1],dist[2]);
    //Soma com distância acumulada
    dist[0] = lambdaAcc*dist[0] + (*distAcc);  // Lo
    dist[1] = lambdaAcc*dist[1] + (*distAcc);  // Hi  
    dist[2] = lambdaAcc*dist[2] + (*distAcc);  // Md
fprintf(stderr, "[%8.6f  %8.6f] ~ %8.6f, Lacc = %8.6f, Dacc = %8.6f\n",dist[0],dist[1],dist[2],lambdaAcc,*distAcc);
  } else {
    // A distancia acumulada é a distância exata:
    dist[0] = dist[1] = dist[2] = (*distAcc);
  }
}

void estima_dist_EUGRADYUV_MultiScale
(
    img_t *Alo, 
    img_t *Ahi,
    img_t *Amd,
    img_t *Asd, 
    img_t *Blo,
    img_t *Bhi,
    img_t *Bmd,
    img_t *Bsd,
    int res,
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float *distAcc,
    double lambda[],
    float dist[]
)
{
  demand(! bgZero, "bgZero com distancia de gradiente nao funciona");

  float_image_t *GAmd = criaImagem_Gradiente(Amd);
  float_image_t *GBmd = criaImagem_Gradiente(Bmd);

  // Calcula distância exata na escala {res} e acumula em {distAcc}:
  float dist_res = calcula_dist_EURGB(GAmd,GBmd,bgZero);
  (*distAcc) += lambda[res]*dist_res;

  if (res > 0) {
    // Calcula estimativas da distância nas escalas {0..res-1} a partir das versões na escala {res}
    dist[0] = 0.0; dist[1] = 1.0; dist[2] = 0.5;
  
    // Calcula peso total dessas estimativas:
    int k;
    float lambdaAcc = 0.0;
    for (k=0;k<res;k++) { lambdaAcc += lambda[k]; }

    //Soma com distância acumulada
    dist[0] = lambdaAcc*dist[0] + (*distAcc);  // Lo
    dist[1] = lambdaAcc*dist[1] + (*distAcc);  // Hi  
    dist[2] = lambdaAcc*dist[2] + (*distAcc);  // Md
  } else {
    // A distancia acumulada é a distância exata:
    dist[0] = dist[1] = dist[2] = (*distAcc);
  }
  float_image_free(GAmd);
  float_image_free(GBmd);
}

