#ifndef LIST_H
#define LIST_H

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

typedef struct image_ref_ {
     float distLo, distHi;
     char name[45];
     int resolucao;
     struct image_ref_ *prox;
}image_ref;

typedef struct image_brilho_ {
     double brilho;
     int x,y;
     struct image_brilho_ *prox;
}image_brilho;

//+++++++++++++++++++++++++++++++Operações Lista Imagens++++++++++++++++++++++++++++++++++++++++++++++++

//insere um novo nó na lista de distancia de imagens
image_ref *insertImage(image_ref *list,float distLo,float distHi,char name[45]);

//insere um novo nó na lista de forma a ordenar pelo menor valor de distLo
image_ref *insertSortImage(image_ref *list,float distLo,float distHi,char name[45],int resolucao);

//remove um nó da lista que contém imagens não desejadas
image_ref *removeImage(image_ref *list,image_ref *img);

//altera os valores das distâncias de um determinado nó a partir do nome
image_ref *editImage(image_ref *list,float distLo,float distHi,char name[45]);

//desaloca todos os nós da lista
void free_Lista(image_ref *list);

//clona a lista passada no parâmetro
image_ref *clone(image_ref *list);

//+++++++++++++++++++++++++++++++Operações Lista Brilho++++++++++++++++++++++++++++++++++++++++++++++++++

//insere um novo nó na lista de forma a ordenar pelo menor valor de brilho
image_brilho *insertSortBrilho(image_brilho *l,double brilho,int x,int y);

//remove um nó da lista que contém as coordenas x e y
image_brilho *removeBrilho(image_brilho *l,image_brilho *bri);

//altera o valor do brilho a partir das coordenadas x e y
image_brilho *editBrilho(image_brilho *l,double brilho,int x,int y);

//desaloca todos os nós da lista de brilhos
void free_ListaBrilho(image_brilho *l);

int compara(image_ref *a, image_ref *b);

image_brilho *criaNo(double brilho,int x,int y);
image_brilho *geralLista(image_brilho vet[],int fim[],int repetido);
void troca(image_brilho a,image_brilho b);
void quickSort(image_brilho vet[],int fim);


/*int compare (const void * a, const void * b);

//image_brilho *insertQuickSortBrilho(image_brilho *l,float brilho,int x,int y,int fim);

image_brilho *insereLista(image_brilho *l,image_brilho *t);

image_brilho *quickSort(image_brilho *l);

image_brilho *insereBrilho(image_brilho *l,double brilho,int x,int y);


//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

image_brilho *FindPrev(image_brilho *list, image_brilho *curr);

image_brilho *SwapNodes(image_brilho *list, image_brilho *no1, image_brilho *no2);

image_brilho *GetNthNode(image_brilho *list, int n);

int NumNodes(image_brilho *list, image_brilho *end);

int countnodes(image_brilho *list);

image_brilho *SelectPivot(image_brilho *list, image_brilho *end);

image_brilho * quicksort(image_brilho *list, int list_start, int list_end);

image_brilho *QSort(image_brilho *list);*/

#endif
