#include <boxes.h>

float_image_t *zeraImagem(float_image_t *img)
{
    int i,j,k;
    for (i=0;i<img->sz[1];i++)
	for (j=0;j<img->sz[2];j++)
		for (k=0;k<img->sz[0];k++)
			float_image_set_sample(img,k,i,j,0.0);
    return img;
}


void identificaBox(char *nomeCaminho,int box[])
{
    float_image_t *img=getImageOpenRGB(nomeCaminho);
    assert(img->sz[0] == 1); /* Só olha para canal 0. Conserte abaixo antes de tirar esta linha. */
    int x,y,valor;
    box[0]=img->sz[2]-1;
    box[1]=img->sz[1]-1;
    box[2]=0;
    box[3]=0;

    //(x0,y0)   (x0,y1)
    //(x1,y0)   (x1,y1)

    for (y=0;y<img->sz[1];y++)
	for (x=0;x<img->sz[2];x++)
	{
		if (float_image_get_sample(img,0,y,x)>0.50)
	    		valor=1;
	    	else
			valor=0;
            	if (valor!=0)
                {
			if (box[0]>x)
				box[0]=x;
			if (box[1]>y)
				box[1]=y;
			if (box[2]<x)
				box[2]=x;
			if (box[3]<y)
				box[3]=y;
		}
	}

    if (box[0]>0)
        box[0]--;
    if (box[1]>0)
        box[1]--;
    if (box[2]<img->sz[1])
        box[2]++;
    if (box[3]<img->sz[2])
        box[3]++;

    float_image_free(img);
}

float_image_t *geraNovaImagem(char *nome,char *dir,int box[],int resolucao)
{
    int i,j,k,x,y,h,w;
    int res=0;
    int dif1=0;
    int dif2=0;
    int valor=0;
    
    h=box[2]-box[0];
    w=box[3]-box[1];

    char *caminho=NULL;
    asprintf(&caminho,"%s/%s/%s",dir,nome,"orig.ppm");
    float_image_t *img=getImageOpenRGB(caminho);

    /* Supõe que a máscara é PGM não PPM */
    asprintf(&caminho,"%s/%s/%s",dir,nome,"mask.pgm");
    float_image_t *mask=getImageOpenRGB(caminho);
    assert(mask->sz[0] == 1); 
    
    if (w>h)
    {
        res=w;
        dif2=(res-h)/2;
    }
    else
    {
        res=h;
        dif1=(res-w)/2;
    }
   /* if (res<0)
	fprintf(stderr, "menor que zero = %s\n",nome);*/
    if (res>=resolucao)
    {
    	FILE *arq=fopen("resolucao.txt","a+");
    	fprintf(arq,"imagem %s %d\n",nome,res);
    	fclose(arq);

    	float_image_t *newimg = float_image_new (3, res, res);
    	newimg=zeraImagem(newimg);

    	y=dif1;
    	for (i=box[1];i<box[3];i++)
    	{
		x=dif2;
		for (j=box[0];j<box[2];j++)
		{
			if (float_image_get_sample(mask,0,i,j)>0.50)
	    			valor=1;
	    		else
				valor=0;
			if (valor==1)
				for (k=0;k<img->sz[0];k++)
					float_image_set_sample(newimg,k,y,x,float_image_get_sample(img,k,i,j));
			x++;
		}
		y++;
    	}

    	float_image_free(img);
    	float_image_free(mask);
    	return newimg;
    }
    return NULL;
}

void gravaBox(char *dir,char *nome,int box[])
{
    char *novo=NULL;
    asprintf(&novo,"%s/%s/bbox.txt",dir,nome);
    FILE *arq = fopen(novo,"w");
    fprintf(arq,"[%d,%d]\n",box[0],box[1]);
    fprintf(arq,"[%d,%d]",box[2],box[3]);
    //fprintf(stderr, "%d %d %d %d\n",box[0],box[1],box[2],box[3]);
    free(novo);
}

void gravaNormalizada(char *dir,char *nome,float_image_t *newimg)
{
    char *novo=NULL;
    asprintf(&novo,"%s/%s/cut.ppm",dir,nome);
    ex_write_image(NULL,novo,newimg);
    free(novo);
}

int main(int argc, char** argv)
{
    char *nome=NULL;
    char *dir=NULL;
    int box[4];
    dir=argv[2];
    char *nomecaminho=NULL;
    nome=argv[1];
    int resolucao=atoi(argv[3]);

    asprintf(&nomecaminho,"%s/%s/mask.ppm",dir,nome);
    //fprintf(stderr, "nome= %s\n",nomecaminho);
    identificaBox(nomecaminho,box);
    gravaBox(dir,nome,box);

    float_image_t *img=geraNovaImagem(nome,dir,box,resolucao);
    if (img!=NULL)
    	gravaNormalizada(dir,nome,img);
    float_image_free(img);
    //free(nome);
    //free(dir);
    //free(nomecaminho);

    return 0;
}
