#include <calculoComparacao.h>

#define DFUNDO (0.25)

//lê a imagem na escala informada
float_image_t *leImagemTipoEscala(char *bandir,char *tipo,int res,char *nome)
{
      char *filename=NULL;
      asprintf(&filename,"%s/%s/%s/R%02d.ppm",bandir,nome,tipo,res);
      float_image_t *I=getImageOpenRGB(filename);
      free(filename);
      return I;
}

/*//remove da lista as imagens que apresentam diastância maior que Hi
image_ref *avaliaDistanciasRGB(image_ref *list,float Hi)
{
   image_ref *aux;

   aux=list;
   while (aux!=NULL)
   {
      if (aux->distLo>Hi)
         list=removeImage(list,aux);
      aux=aux->prox;
   }
   return list;
}*/

/*
float dLoRGB(float aLo,float aHi,float bLo,float bHi)
{
   float valor=-1;
   if ((aLo<=bHi)&&(aHi>=bLo))
      valor=0.0;
   else if (aLo>bHi)
      valor=fabs(aLo-bHi);
   else if (aHi<bLo)
      valor=fabs(aHi-bLo);
   return valor;
}

float dHiRGB(float aLo,float aHi,float bLo,float bHi)
{
   float valor=aHi-bLo;
   if (valor<(bHi-aLo))
      valor=bHi-aLo;
   return valor;
}

*/

//função do cálculo da distância dlo
float dLoRGB(float aLo,float aHi,float bLo,float bHi)
{
   float ahi=aHi,blo=bLo;
   if (aLo>bLo)
   {
	ahi=bHi;
	blo=aLo;
   }
   if (ahi>=blo)
	return 0;
   else if ((aLo==0)&&(aHi==0))
	return DFUNDO;
   else if ((bLo==0)&&(bHi==0))
	return DFUNDO;
   else if (aHi < bLo)
	return (bLo-aHi);
   else if (aLo > bHi)
	return (aLo-bHi);
   return 1;
}

//função do cálculo da distância dhi
float dHiRGB(float aLo,float aHi,float bLo,float bHi)
{
   if ((aLo==0)&&(aHi==0)&&(bLo==0)&&(bHi==0))
	return 0;
   else if ((aLo == 0) || (bLo == 0))
	return DFUNDO;
   else
   {
	float a=fabs(aHi-bLo);
	float b=fabs(bHi-aLo);
	if (a>b)
      		return a;
	else
		return b;
   }	
}

//realiza o cálculo da distância distlo entre duas imagens
float distLoRGB(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0,k=0;
   float valor=0.0,soma=0.0;
   for (k=0;k<3;k++)
   {
     for (i=0;i<Alo->sz[1];i++)
     {
	for (j=0;j<Alo->sz[2];j++)
	{
           valor=dLoRGB(float_image_get_sample(Alo,k,i,j),float_image_get_sample(Ahi,k,i,j),float_image_get_sample(Blo,k,i,j),float_image_get_sample(Bhi,k,i,j));
           soma+=valor;
        }
     }
   }
   i=Alo->sz[1]*Alo->sz[2]*3;
   soma=soma/i;
   return soma;
}

//realiza o cálculo da distância disthi entre duas imagens
float distHiRGB(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0,k=0;
   float valor=0.0,soma=0.0;
   for (k=0;k<3;k++)
   {
     for (i=0;i<Alo->sz[1];i++)
     {
	for (j=0;j<Alo->sz[2];j++)
	{
           valor=dHiRGB(float_image_get_sample(Alo,k,i,j),float_image_get_sample(Ahi,k,i,j),float_image_get_sample(Blo,k,i,j),float_image_get_sample(Bhi,k,i,j));
           soma+=valor;
        }
     }
   }
   i=Alo->sz[1]*Alo->sz[2]*3;
   soma=soma/i;
   return soma;
}

//retira da lista as imagens em que a distância distlo é maior que uma disthi estabelecida
image_ref *removeImagensMaioresDist(image_ref *list,float disthi)
{
   image_ref *aux,*aux2;
   aux=list->prox;
   while (aux!=NULL)
   {
      if ((aux->distLo)>disthi)
      {
          aux2=aux;
          printf("  Imagem  %s %02d  %8.6f  %8.6f eliminada \n",aux->name,aux->resolucao,aux->distLo,aux->distHi);
          aux=aux->prox;
          list=removeImage(list,aux2);
      }
      else
         aux=aux->prox;
   }
   return list;
}


//identifica a menor distância disthi
float menorDistHi(image_ref *list)
{
   float distHiMin = 999999;
   while (list!=NULL)
   {
      if ((list->distHi) < distHiMin) distHiMin = list->distHi;
      list = list->prox;
   }
   return distHiMin;
}

void escreveResultado(FILE *arq,image_ref *aux)
{
   fprintf(arq,"%s  %02d  %8.6f  %8.6f\n",aux->name,aux->resolucao,aux->distLo,aux->distHi);
}

void escreveListaResultados(FILE *arq,image_ref *list)
{
   image_ref *aux=list;
   while (aux!=NULL)
   {
       escreveResultado(arq,aux);
      aux=aux->prox;
   }
}
/*
//nova seleção considerando os diversos níveis juntos
image_ref *selecaoImagemOrdenadasRGB
  ( char *bandir,
    int num,
    int res_max,
    int fator,
    char *model_name,
    int vet[] )
  {
   image_ref *list;
   int res;
   for (res = 0; res < res_max; res++) { vet[res] = 0; }
   vet[res_max] = num-1;
   list=criaListaOrdenadaRGB(bandir,num,model_name);
   float distMax=menorDistHi(list);
   list=removeImagensMaioresDist(list,distMax);
   printf("\n\n\n\n\n");

   int num_resultados = 0;
   int num_resultados_desejados = 5;
   int cont=0;

   char *res_filename=NULL;
   asprintf(&res_filename,"%s/%s/resultados.txt",bandir,model_name);
   FILE *arq = fopen(res_filename,"w");
   fprintf(arq,"#Resultados\n");
   fprintf(arq,"#Nome  DistMin  DistMax  Resolução\n");

   while (list!=NULL)
   {
      //Gera um arquivo com as informações atuais
      drawList(list,bandir,model_name,list->distLo,distMax,num,cont);
      cont++;

      if ((list->distLo==list->distHi)||(list->resolucao==0))
      {
          escreveResultado(arq,list);
          num_resultados++;
          list=removeImage(list,list);
          if (num_resultados>=num_resultados_desejados)
             break;
      }
      else
      {
         int res=list->resolucao-1;
         char *bname=list->name;

         float_image_t *Alo=leImagemTipoEscala(bandir,"Lo",res,model_name);
         float_image_t *Ahi=leImagemTipoEscala(bandir,"Hi",res,model_name);

         float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,bname);
         float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,bname);
	
	 float oldLo=list->distLo;
	 float oldHi=list->distHi;
         list=removeImage(list,list);

	 float distlo=distLoRGB(Alo,Ahi,Blo,Bhi);
         float disthi=distHiRGB(Alo,Ahi,Blo,Bhi);
	 assert(oldLo<=distlo);
	 assert(oldHi>=disthi);
         vet[res]++;
         printf("Imagem  %s %02d  %8.6f  %8.6f refinada\n",bname,res,distlo,disthi);

         list=insertSortImage(list,distlo,disthi,bname,res);

         float_image_free(Alo);
         float_image_free(Ahi);
         float_image_free(Blo);
         float_image_free(Bhi);
         if (disthi<distMax)
         {
		

            distMax=disthi;
            list=removeImagensMaioresDist(list,distMax);	    
         }
      }
   }
   fputs("\n#Imagens Restantantes\n",arq);
   escreveListaResultados(arq,list);
   fputs("\n\n#Fim dos Resultados\n",arq);
   fclose(arq);
   return list;
}*/

image_ref *selecaoImagemOrdenadasRGB(char *bandir,int num,int res_max,int fator,char *model_name,int vet[])
{
	image_ref *list;
	int res;
	for (res = 0; res < res_max; res++) { vet[res] = 0; }
	vet[res_max] = num-1;
	list=criaListaOrdenadaRGB(bandir,num,model_name);
	float distMax=menorDistHi(list);
	list=removeImagensMaioresDist(list,distMax);
	printf("\n\n\n\n\n");

	int num_resultados = 0;
	int num_resultados_desejados = 5;
	int cont=0,i;
	char *res_filename=NULL;
	float_image_t modeloHi[res_max];
	float_image_t modeloLo[res_max];

	for (i=1;i<res_max;i++)
	{
		modeloLo[i]=leImagemTipoEscala(bandir,"Lo",i,model_name);
		modeloHi[i]=leImagemTipoEscala(bandir,"Hi",i,model_name);
	}

	asprintf(&res_filename,"%s/%s/resultados.txt",bandir,model_name);
	FILE *arq = fopen(res_filename,"w");
	fprintf(arq,"#Resultados\n");
	fprintf(arq,"#Nome  DistMin  DistMax  Resolução\n");
	
	while (list!=NULL)
	{
		//Gera um arquivo com as informações atuais
		drawList(list,bandir,model_name,list->distLo,distMax,num,cont);
		cont++;

		if ((list->distLo==list->distHi)||(list->resolucao==0))
		{
			escreveResultado(arq,list);
			num_resultados++;
			list=removeImage(list,list);
			if (num_resultados>=num_resultados_desejados)
				break;
		}
		else
		{
			int res=list->resolucao-1;
			char *bname=list->name;

			float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,bname);
			float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,bname);
	
			float oldLo=list->distLo;
			float oldHi=list->distHi;
			list=removeImage(list,list);

			float distlo=distLoRGB(modeloLo[res],modeloHi[res],Blo,Bhi);
			float disthi=distHiRGB(modeloLo[res],modeloHi[res],Blo,Bhi);
			assert(oldLo<=distlo);
			assert(oldHi>=disthi);
			vet[res]++;
			printf("Imagem  %s %02d  %8.6f  %8.6f refinada\n",bname,res,distlo,disthi);

			list=insertSortImage(list,distlo,disthi,bname,res);

			float_image_free(Blo);
			float_image_free(Bhi);

			if (disthi<distMax)
			{
				distMax=disthi;
				list=removeImagensMaioresDist(list,distMax);	    
			}
		}
	}

	for (i=0;i<res_max;i++)
	{
		float_image_free(modeloLo[i]);
		float_image_free(modeloHi[i]);
	}
	fputs("\n#Imagens Restantantes\n",arq);
	escreveListaResultados(arq,list);
	fputs("\n\n#Fim dos Resultados\n",arq);
	fclose(arq);
	return list;
}

//cálcula a porcentagem de custo em relação aos métodos originais
float calculaCusto(int vet[],int num)
{
   int i;
   float custo=0;
   for (i=0;i<6;i++)
   {
      custo+=vet[i]*pow(0.25,i);
   }
   return custo/num;
}
