#include <distancias.h>

//////////////////////////////////////////////////////////////////////////////
/*

//funções distância


//-----função do cálculo da distância intervalar Lo
float dLo(float aLo,float aHi,float bLo,float bHi)
{
   float ahi=aHi,blo=bLo;
   if (aLo>bLo)
   {
	ahi=bHi;
	blo=aLo;
   }
   if (ahi>=blo)
	return 0;
   else if ((aLo==0)&&(aHi==0))
	return DFUNDO;
   else if ((bLo==0)&&(bHi==0))
	return DFUNDO;
   else if (aHi < bLo)
	return (bLo-aHi);
   else if (aLo > bHi)
	return (aLo-bHi);
   return 1;
}

//-----função do cálculo da distância intervalar Hi
float dHi(float aLo,float aHi,float bLo,float bHi)
{
   if ((aLo==0)&&(aHi==0)&&(bLo==0)&&(bHi==0))
	return 0;
   else if ((aLo == 0) || (bLo == 0))
	return DFUNDO;
   else
   {
	float a=fabs(aHi-bLo);
	float b=fabs(bHi-aLo);
	if (a>b)
      		return a;
	else
		return b;
   }	
}


//distância de Manhattan

//*********************************

  //exata

void dist_Manhattan_Exata()
{

}

//*********************************

  //intervalar

//-----realiza o cálculo da distância distlo entre duas imagens
float distLo_Manhattan(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0,k=0;
   float valor=0.0,soma=0.0;
   for (k=0;k<3;k++)
   {
     for (i=0;i<Alo->sz[1];i++)
     {
	for (j=0;j<Alo->sz[2];j++)
	{
           valor=dLo(float_image_get_sample(Alo,k,i,j),float_image_get_sample(Ahi,k,i,j),float_image_get_sample(Blo,k,i,j),float_image_get_sample(Bhi,k,i,j));
           soma+=valor;
        }
     }
   }
   i=Alo->sz[1]*Alo->sz[2]*3;
   soma=soma/i;
   return soma;
}

//-----realiza o cálculo da distância disthi entre duas imagens
float distHi_Manhattan(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0,k=0;
   float valor=0.0,soma=0.0;
   for (k=0;k<3;k++)
   {
     for (i=0;i<Alo->sz[1];i++)
     {
	for (j=0;j<Alo->sz[2];j++)
	{
           valor=dHi(float_image_get_sample(Alo,k,i,j),float_image_get_sample(Ahi,k,i,j),float_image_get_sample(Blo,k,i,j),float_image_get_sample(Bhi,k,i,j));
           soma+=valor;
        }
     }
   }
   i=Alo->sz[1]*Alo->sz[2]*3;
   soma=soma/i;
   return soma;
}

void dist_Manhattan_Inter(char *bandir,int num,int res_max,int fator,char *model_name,int num_resultados_desejados,int vet[])
{
   image_ref *list;
   int i,res,num_resultados = 0;
   char *res_filename=NULL;
   float_image_t model_res_Lo[res_max];
   float_image_t model_res_Hi[res_max];

   list=criaListaOrdenadaRGB(bandir,num,model_name);
   float distMax=menorDistHi(list);
   list=removeImagensMaioresDist(list,distMax);

   for (res = 0; res < res_max; res++) 
   { 
	vet[res] = 0; 
	model_res_Lo[res]=leImagemTipoEscala(bandir,"Lo",res,model_name);
	model_res_Hi[res]=leImagemTipoEscala(bandir,"Hi",res,model_name);
   }
   vet[res_max] = num-1;

   asprintf(&res_filename,"%s/%s/resultados.txt",bandir,model_name);
   FILE *arq = fopen(res_filename,"w");
   fprintf(arq,"#Resultados\n");
   fprintf(arq,"#Nome  DistMin  DistMax  Resolução\n");

   while (list!=NULL)
   {

      if ((list->distLo==list->distHi)||(list->resolucao==0))
      {
          escreveResultado(arq,list);
          num_resultados++;
          list=removeImage(list,list);
          if (num_resultados>=num_resultados_desejados)
             break;
      }
      else
      {
         res=list->resolucao-1;
         char *bname=list->name;

         float_image_t *Blo=leImagemTipoEscala(bandir,"Lo",res,bname);
         float_image_t *Bhi=leImagemTipoEscala(bandir,"Hi",res,bname);
	
         list=removeImage(list,list);

	 float distlo=distLo_Manhattan(model_res_Lo[res],model_res_Hi[res],Blo,Bhi);
         float disthi=distHi_Manhattan(model_res_Lo[res],model_res_Hi[res],Blo,Bhi);
	 assert(oldLo<=distlo);
	 assert(oldHi>=disthi);
         vet[res]++;

         printf("Imagem  %s %02d  %8.6f  %8.6f refinada\n",bname,res,distlo,disthi);

         list=insertSortImage(list,distlo,disthi,bname,res);

         float_image_free(Blo);
         float_image_free(Bhi);

         if (disthi<distMax)
         {
            distMax=disthi;
            list=removeImagensMaioresDist(list,distMax);
         }
      }
   }

   for (res=0;res < res_max;res++)
   {
	float_image_free(model_res_Lo[res]);
        float_image_free(model_res_Hi[res]);
   }

   fputs("\n#Imagens Restantantes\n",arq);
   escreveListaResultados(arq,list);
   fputs("\n\n#Fim dos Resultados\n",arq);
   fclose(arq);
   free_Lista(list);
}

//*********************************

  //média/desvio padrão

void dist_Manhattan_MdSd()
{

}

//////////////////////////////////////////////////////////////////////////////

//distância de Hausdorff

//*********************************

  //exata

void dist_Hausdorff_Exata()
{

}

//*********************************

  //intervalar

void dist_Hausdorff_Inter()
{

}

//*********************************

  //média/desvio padrão

void dist_Hausdorff_MdSd()
{

}

//////////////////////////////////////////////////////////////////////////////

//distância de Terraplanagem

//*********************************

  //exata

void dist_Terraplanagem_Exata()
{

}

//*********************************

  //intervalar

void dist_Terraplanagem_Exata()
{

}

//*********************************

  //média/desvio padrão

void dist_Terraplanagem_Exata()
{

}
*/
//////////////////////////////////////////////////////////////////////////////
