#define _GNU_SOURCE
#include <math.h>
#include <geraYuvGrad.h>

#include <sample_conv.h>
#include <frgb_ops.h>
#include <frgb.h>
#include <float_image_gradient_2.h>
#include <operacoes.h>
#include <string.h>

#define NOISE 0.05
#define YBIAS 0.00


//INTERNAS

void criaImagemYUV_Gradiente(char *bandir,char *nome,char *outdir);

float_image_t *criaImagemYUV(float_image_t *img, frgb_t *vmin, frgb_t *vmax);

void calculaSQRT_Canal(float_image_t *img,int ch,float *max);

float_image_t *calculaGradiente(float_image_t *img);

void ajustaCanaisGravacao(float_image_t *img);

float_image_t *ajustaGradiente(float_image_t *grad,float_image_t *yuv,float max);

float_image_t *criaImagemRGB(float_image_t *img);

void testaCanais(float_image_t *img);


//IMPLEMENTAÇÕES

float_image_t *criaImagemYUV(float_image_t *img, frgb_t *vmin, frgb_t *vmax)
{
  int i,j,ch;
  frgb_t rgb;
  float_image_t *yuv=float_image_new(img->sz[0],img->sz[1],img->sz[2]);
  for (ch=0;ch<img->sz[0];ch++) { vmin->c[ch] = +INF; vmax->c[ch] = -INF; }
  for (i=0;i<img->sz[1];i++)
  {
    for (j=0;j<img->sz[2];j++)
    {
      for (ch=0;ch<img->sz[0];ch++)
      {
        rgb.c[ch]=float_image_get_sample(img,ch,i,j);
      }
      frgb_to_YUV(&rgb);
      frgb_YUV_to_Yuv(&rgb,YBIAS);
      for (ch=0;ch<img->sz[0];ch++)
      {
        if(isnan(rgb.c[ch])){ rgb.c[ch] = (ch==0?0.5:0.0); }
        float_image_set_sample(yuv,ch,i,j,rgb.c[ch]);
        if (rgb.c[ch] < vmin->c[ch]) { vmin->c[ch] = rgb.c[ch]; } 
        if (rgb.c[ch] > vmax->c[ch]) { vmax->c[ch] = rgb.c[ch]; }
      }
    }
  }
  return yuv;
}

void calculaSQRT_Canal(float_image_t *img,int ch,float *max)
{
  int i,j;
  float valor=0.0;
  *max=0;
  for (i=0;i<img->sz[1];i++)
  {
    for (j=0;j<img->sz[2];j++)
    {
      valor=float_image_get_sample(img,ch,i,j);
      float_image_set_sample(img,ch,i,j,sqrt(valor));
      if (*max<valor)
         *max=valor;
    }
  }
}

float_image_t *ajustaGradiente(float_image_t *grad,float_image_t *yuv,float max)
{
  int i,j;
  float valorGrad;
  float valorYuv;
  float valor;
  float_image_t *img=float_image_new(yuv->sz[0],yuv->sz[1],yuv->sz[2]);
  for (i=0;i<yuv->sz[1];i++)
  {
    for (j=0;j<yuv->sz[2];j++)
    {
      valorGrad=float_image_get_sample(grad,0,i,j);

      valor=((valorGrad/max)/2)+0.5;

      float_image_set_sample(img,0,i,j,valor);

      valorYuv=float_image_get_sample(yuv,1,i,j);

      float_image_set_sample(img,1,i,j,valorYuv);

      valorYuv=float_image_get_sample(yuv,2,i,j);

      float_image_set_sample(img,2,i,j,valorYuv);
    }
  }
  return img;
}

float_image_t *calculaGradiente(float_image_t *yuv)
{
  float_image_t *grad=float_image_new(yuv->sz[0],yuv->sz[1],yuv->sz[2]);;
  float_image_gradient_sqr_relative_2(yuv,0,NOISE,grad,0);
  float max;
  calculaSQRT_Canal(grad,0,&max);
  float_image_t *adj=ajustaGradiente(grad,yuv,max);
  float_image_free(grad);
  return adj;
}

void ajustaCanaisGravacao(float_image_t *img)
{
  int i,j,ch;
  float valor;
  for (i=0;i<img->sz[1];i++)
  {
    for (j=0;j<img->sz[2];j++)
    {
      for (ch=0;ch<img->sz[0];ch++)
      {
        valor=float_image_get_sample(img,ch,i,j);
        if (ch==0)
        {
          if (valor>1)
          { valor=1; }
          else if (valor<0)
          { valor=0; }
        }
        else
        {
          if (valor>+1)
          { valor=+1; }
          else if (valor<-1)
          { valor=-1; }
        }
        float_image_set_sample(img,ch,i,j,valor);
      }
    }
  }
}

float_image_t *criaImagemRGB(float_image_t *img)
{
  int i,j,ch;
  frgb_t rgb;
  float_image_t *res=float_image_new(img->sz[0],img->sz[1],img->sz[2]);
  for (i=0;i<img->sz[1];i++)
  {
    for (j=0;j<img->sz[2];j++)
    {
      for (ch=0;ch<img->sz[0];ch++)
      {
        rgb.c[ch]=float_image_get_sample(img,ch,i,j);
      }
      frgb_YUV_from_Yuv(&rgb,YBIAS);
      frgb_from_YUV(&rgb);
      for (ch=0;ch<img->sz[0];ch++)
      {
        float_image_set_sample(res,ch,i,j,rgb.c[ch]);
      }
    }
  }
  return res;
}

void testaCanais(float_image_t *img)
{
  int i,j,ch;
  float valor;
  for (i=0;i<img->sz[1];i++)
  {
    for (j=0;j<img->sz[2];j++)
    {
      for (ch=0;ch<img->sz[0];ch++)
      {
        valor=float_image_get_sample(img,ch,i,j);
        if (isnan(valor))
        {
          fprintf(stderr,"X:%d, Y:%d, CH:%d\n",i,j,ch);
          float_image_set_sample(img,ch,i,j,0.5);
        }
      }
    }
  }
}

void criaImagemYUV_Gradiente(char *bandir,char *nome,char *outdir)
{
  char *filename=NULL;
  asprintf(&filename,"%s/%s/norm.ppm",bandir,nome);
  float_image_t *img=getImageOpenRGB(filename,ZER);

  frgb_t tt = (frgb_t){{ 0.5, 0.3, 0.4 }};
  frgb_YUV_to_Yuv(&tt, 0.01);
  frgb_YUV_from_Yuv(&tt, 0.01);
  frgb_print(stderr, "test = ", &tt, "\n");

  fprintf(stderr, "Criando imagem YUV\n");
  frgb_t vmin, vmax;
  float_image_t *yuv=criaImagemYUV(img, &vmin, &vmax);
  frgb_print(stderr, "vmin = ", &vmin, "\n");
  frgb_print(stderr, "vmax = ", &vmax, "\n");

  fprintf(stderr, "Criando imagem Gradiente\n"); 
  float_image_t *grad=calculaGradiente(yuv);

  fprintf(stderr, "Criando imagem RGB\n"); 
  float_image_t *rgb=criaImagemRGB(grad);

  fprintf(stderr, "Testando imagem RGB\n"); 
  testaCanais(rgb);

  fprintf(stderr, "Gravando imagem RGB\n"); 
  asprintf(&filename,"%s/%s/norm.ppm",outdir,nome);
  ex_write_image(NULL,filename,rgb);
  float_image_free(rgb);
  float_image_free(img);
  float_image_free(yuv);
  float_image_free(grad);
  free(filename);
}

int main(int argc, char** argv)
{
  char *bandir = argv[1];
  char *nome = argv[2];
  char *outdir = argv[3];

  fprintf(stderr, "parametros:\n");
  fprintf(stderr, "diretório do banco = %s\n", bandir);
  fprintf(stderr, "nome (número) da imagem a reduzir = %s\n", nome);
  fprintf(stderr, "diretório de saída das imagens = %s\n", outdir);

  criaImagemYUV_Gradiente(bandir,nome,outdir);

  return 0;
}
