#include <principal.h>

//realiza a cópia de uma imagem
float_image_t *copiaImagem(float_image_t *I,float_image_t *N)
{
   //float_image_t *A=float_image_new(1,I->sz[1],I->sz[2]);
   int i=0,j=0;
   for (i=0;i<I->sz[1];i++)   
	for (j=0;j<I->sz[2];j++)
        {
            float_image_set_sample(N,0,i,j,float_image_get_sample(I,0,i,j));
        }
   return N;
}

//realiza a redução em um fator determinado por parametro
void reduzFatorK(float_image_t *I,char name[45],int fator)
{
   int i=0,k=2;
   float_image_t *media;
   float_image_t *variancia;
   float_image_t *intervaloLo;
   float_image_t *intervaloHi;
   media=float_image_new(1,I->sz[1],I->sz[2]);
   variancia=float_image_new(1,I->sz[1],I->sz[2]);
   intervaloLo=float_image_new(1,I->sz[1],I->sz[2]);
   intervaloHi=float_image_new(1,I->sz[1],I->sz[2]);
   media=copiaImagem(I,media);
   variancia=copiaImagem(I,variancia);
   intervaloLo=copiaImagem(I,intervaloLo);
   intervaloHi=copiaImagem(I,intervaloHi);
   //FILE *A,*B,*C,*D;
   char cont[15],str[45];
   for (i=0;i<fator;i++)
   {  
      media=calculaMedia(media,k);
      variancia=calculaVariancia(variancia,media,k);
      intervaloLo=calculaIntervaloLo(intervaloLo,k,0.0);
      intervaloHi=calculaIntervaloHi(intervaloHi,k,0.0);

      sprintf(cont, "%d", i+1);
      strcpy(str,"");
      strcat(str,name);
      strcat(str,"Media_");
      strcat(str,cont);
      strcat(str,".pgm");
      ex_write_image(NULL,str,media);
      
      strcpy(str,"");
      strcat(str,name);
      strcat(str,"Variancia_");
      strcat(str,cont);
      strcat(str,".pgm");
      ex_write_image(NULL,str,variancia);
      
      strcpy(str,"");
      strcat(str,name);
      strcat(str,"InterMenor_");
      strcat(str,cont);
      strcat(str,".pgm");
      ex_write_image(NULL,str,intervaloLo);
      
      strcpy(str,"");
      strcat(str,name);
      strcat(str,"InterMaior_");
      strcat(str,cont);
      strcat(str,".pgm");
      ex_write_image(NULL,str,intervaloHi);
      
   }
   float_image_free(media);
   float_image_free(variancia);
   float_image_free(intervaloLo);
   float_image_free(intervaloHi);
}

float_image_t *getImageOpen(float_image_t *I,char name[255])
{
   if (strlen(name)>=1)
   {
      FILE *arq;
      arq = fopen(name,"rw");
      I = ex_read_image(arq, name);
      fclose(arq);
      return I;
   }
   return NULL;
}

void reduzImagens(int num,int fator)
{
   int i=0;
   char cont[5];
   char str[45];
   char name[45];
   float_image_t *I = NULL;
   for (i=0;i<num;i++)
   {
      sprintf(cont, "%d", i+1);
      strcpy(str,"");
      strcat(str,"../Imagens/img");
      strcat(str,cont);
      strcat(str,".pgm");
      //fprintf(stderr, "%s\n",str);
      strcpy(name,"img");
      strcat(name,cont);
      I=getImageOpen(I,str);
      //m=I->sz[1];
      //n=I->sz[2];
      //fprintf(stderr, "%d  %d\n",m,n);
      reduzFatorK(I,name,fator);
      float_image_free(I);
   }
}

float dLo(float aLo,float aHi,float bLo,float bHi)
{
   float valor=-1;
   if ((aLo<=bHi)&&(aHi>=bLo))
      valor=0.0;
   else if (aLo>bHi)
      valor=fabs(aLo-bHi);
   else if (aHi<bLo)
      valor=fabs(aHi-bLo);
   return valor;
}

float dHi(float aLo,float aHi,float bLo,float bHi)
{
   float valor=aHi-bLo;
   if (valor<(bHi-aLo))
      valor=bHi-aLo;
   return valor;
}

float distLo(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0;
   float valor=0.0,aLo=0.0,aHi=0.0,bLo=0.0,bHi=0.0,soma=0.0;
   for (i=0;i<Alo->sz[1];i++)
   {
	for (j=0;j<Alo->sz[2];j++)	
	{	
           aLo=float_image_get_sample(Alo,0,i,j);
           aHi=float_image_get_sample(Ahi,0,i,j);
           bLo=float_image_get_sample(Blo,0,i,j);
           bHi=float_image_get_sample(Bhi,0,i,j);      
           valor=dLo(aLo,aHi,bLo,bHi);
           soma+=valor*valor;
        }
   }
   soma=(sqrt(soma)/(Alo->sz[1]*Alo->sz[2]));
   return soma;
}

float distHi(float_image_t *Alo,float_image_t *Ahi,float_image_t *Blo,float_image_t *Bhi)
{
   int i=0,j=0;
   float valor=0.0,aLo=0.0,aHi=0.0,bLo=0.0,bHi=0.0,soma=0.0;
   for (i=0;i<Alo->sz[1];i++)
   {
	for (j=0;j<Alo->sz[2];j++)	
	{	
           aLo=float_image_get_sample(Alo,0,i,j);
           aHi=float_image_get_sample(Ahi,0,i,j);
           bLo=float_image_get_sample(Blo,0,i,j);
           bHi=float_image_get_sample(Bhi,0,i,j);      
           valor=dHi(aLo,aHi,bLo,bHi);
           soma+=valor*valor;
        }
   }
   soma=(sqrt(soma)/(Alo->sz[1]*Alo->sz[2]));
   return soma;
}

image_ref *criaLista(image_ref *list,int num,char name[45])
{
   
   int i=0;   
   char str[30],cont[15];
   for (i=0;i<num;i++)
   {
      sprintf(cont, "%d", i+1);
      strcpy(str,"");
      strcat(str,"img");
      strcat(str,cont);
      
      if (strcmp(name, str))
      {
         list=insertImage(list,0.0,0.0,str);         
      }
   }
   return list;
}

image_ref *avaliaDistancias(image_ref *list,float Hi)
{
   image_ref *aux;

   aux=list;
   while (aux!=NULL)
   {
      //fprintf(stderr, "Avalia: dist: %4.4f  hi: %4.4f\n",aux->distLo,Hi);
      if (aux->distLo>Hi)
         list=removeImage(list,aux);
      aux=aux->prox;
   }
   return list;
}

void armazenaRezultados(image_ref *list,int numResult)
{
   FILE *arq;
   char c[5],str[25],cont[5];
   sprintf(c, "%d", numResult+1);
   strcpy(str,"");
   strcat(str,"resultados");
   strcat(str,c);
   strcat(str,".txt");
   arq=fopen(str,"w");
   strcpy(str,"");
   strcat(str,"#Resultados ");
   strcat(str,c);
   strcat(str,"\n");
   fputs(str,arq);
   strcpy(str,"");
   strcat(str,"\n#Nome  DistMin  DistMax");
   fputs(str,arq);
   while (list!=NULL)
   {
      strcpy(str,"\n");
      strcat(str,list->name);
      strcat(str,".pgm  ");
      sprintf(cont, "%4.8f", list->distLo);
      strcat(str,cont);
      strcat(str,"  ");
      sprintf(cont, "%4.8f", list->distHi);
      strcat(str,cont);
      fputs(str,arq);
      list=list->prox;
   }
   fputs("\n\n#Fim dos Resultados",arq);
   fclose(arq);
}

void exibeMelhores(image_ref *list)
{
   image_ref *aux;
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   while (list!=NULL)
   {
      fprintf(stderr, "Nome: %s, DistLo: %4.4f, DistHi: %4.4f\n",list->name,list->distLo,list->distHi);
      aux=list;
      list=list->prox;
   }
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
}

image_ref *selecionaImagens(int num,char name[45],int fator)
{
   image_ref *aux;
   image_ref *list;
   list=NULL;
   list=criaLista(list,num,name);
   aux=list;
   float_image_t *Alo=NULL, *Ahi=NULL, *Blo=NULL, *Bhi=NULL;
   int i=0;
   float distlo=0.0,disthi=0.0,Hi=0;
   char str[30],cont[15];
   fprintf(stderr, "\n\n");
   for (i=fator;i>0;i--)
   { 
     strcpy(str,"");
     strcat(str,name);
     strcat(str,"InterMenor_");
     sprintf(cont, "%d", i);
     strcat(str,cont);
     strcat(str,".pgm");
     Alo=getImageOpen(Alo,str);

     strcpy(str,"");
     strcat(str,name);
     strcat(str,"InterMaior_");
     strcat(str,cont);
     strcat(str,".pgm");
     Ahi=getImageOpen(Ahi,str);
     Hi=1.0e20;
     while (aux!=NULL)
     {
        strcpy(str,"");
        strcat(str,aux->name);
        strcat(str,"InterMenor_");
        strcat(str,cont);
        strcat(str,".pgm");
        Blo=getImageOpen(Blo,str);      

        strcpy(str,"");
        strcat(str,aux->name);
        strcat(str,"InterMaior_");
        strcat(str,cont);
        strcat(str,".pgm");
        Bhi=getImageOpen(Bhi,str);
      
        distlo=distLo(Alo,Ahi,Blo,Bhi);
        disthi=distHi(Alo,Ahi,Blo,Bhi);
	
        //fprintf(stderr, "Min %4.4f\n",distlo);
        //fprintf(stderr, "Max %4.4f\n",disthi);

        if (Hi>disthi)
           Hi=disthi;
        
        list=editImage(list,distlo,disthi,aux->name);
        aux=aux->prox;
        float_image_free(Blo);
        float_image_free(Bhi);
     }
     list=avaliaDistancias(list,Hi);
     armazenaRezultados(list,fator-i);
     aux=list;
     float_image_free(Alo);
     float_image_free(Ahi);
   }
   return list;
}


void comparaImagens(int num,char name[45],int fator)
{
   image_ref *list;
   fprintf(stderr, "\n+++++++++++++++++++++++++++++++INICIO++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
   //reduzImagens(num,fator);
   list=selecionaImagens(num,name,fator);
   //exibeMelhores(list);
   free_Lista(list);
   fprintf(stderr, "\n++++++++++++++++++++++++++++++++++FIM++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
   
}

int main(int argc, char** argv)
{   
  // Coloque antes de alocar
  void *trash = malloc(1);                 
  struct mallinfo info;   
  int MemDinInicial, MemDinFinal;
  free(trash); 
  info = mallinfo();
  MemDinInicial = info.uordblks;


  //fprintf(stderr, "Digite o nome da imagem \n");
  //scanf("%s",&name);
  //strcpy(name,"img3");
  comparaImagens(1000,"img3",5);

  info = mallinfo();
  MemDinFinal = info.uordblks;
  if (MemDinInicial!=MemDinFinal)
    fprintf(stderr, "\n\nMain loop: Dinamic memory was not completely deallocated (%d, %d)\n", MemDinInicial,MemDinFinal);
  
  return 0;
}

/* LEITURA E GRAVACÃO DA IMAGEM */

float_image_t *ex_read_image(FILE *rd, char *name)
  { bool_t close_it = FALSE;
    if (rd == NULL) { rd = open_read(name, TRUE); close_it = TRUE; }
    pnm_image_t *pim = pnm_image_fread(rd);
    float_image_t *fim = float_image_from_pnm_image(pim, NULL, NULL, FALSE);
    pnm_image_free(pim);
    if (close_it) { fclose(rd); }
    return fim;
  }
