#include <reducao.h>


//funções do arquivo
float getMediaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc);
void getVarianciaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float m,float vet[2]);
void getInterMenorMaiorRegiao(float_image_t *I,float vet[2],int inil,int fiml,int inic,int fimc,float intervalo);
float calculaMediaVarianciaIntervalos(float_image_t *I,float_image_t *vet[4],int k,float intervalo);
float_image_t *getImageEscalada(float_image_t *J,float vari);
float_image_t *calculaMedia(float_image_t *I,int k);
float_image_t *calculaVariancia(float_image_t *I,float_image_t *J,int k);
float_image_t *calculaIntervaloLo(float_image_t *I,int k,float intervalo);
float_image_t *calculaIntervaloHi(float_image_t *I,int k,float intervalo);

//Média Aritmética da Região
float getMediaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc)
{
  int i=0,j=0;
  float soma=0;
  for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
         soma+=float_image_get_sample(I,0,i,j);
     }
  i=(fiml-inil)*(fimc-inic);
  return soma/(i);
}

//Variancia da Região retornada em vet[0] e o maior valor em vet[1]
void getVarianciaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float m,float vet[2])
{
   int i=0,j=0;
   float soma=0.0,valor=0.0;   
   for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
         valor=float_image_get_sample(I,0,i,j)-m;
         valor=valor*valor;
         if (vet[1]<=valor)
            vet[1]=valor;
         soma+=valor;
     }
   i=(fiml-inil)*(fimc-inic)-1;
   vet[0]=soma/(i);
}

//identifica o maior e o menor intervalo de uma região sendo o menor em vet[0] e o maior em vet[1]
void getInterMenorMaiorRegiao(float_image_t *I,float vet[2],int inil,int fiml,int inic,int fimc,float intervalo)
{
  int i=0,j=0;
  float menor=1,maior=0,valor=0;
  for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
        valor=float_image_get_sample(I,0,i,j);
        if (menor>(valor-intervalo))
            menor=valor-intervalo;
        if (maior<valor+intervalo)
            maior=valor+intervalo;
     }
     vet[0]=menor;
     vet[1]=maior;
}

//realiza o cálculo da média (vet[0]), variancia (vet[1]), baixos intervalos (vet[2]) e altos intervalos (vet[3])
float calculaMediaVarianciaIntervalos(float_image_t *I,float_image_t *vet[4],int k,float intervalo)
{
   int i=0,j=0,x=0,y=0;
   float media=0.0,variancia[2];
   float cInter[2];//vetor que recebe os menores e maiores intervalos
   float_image_t *D=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de média
   float_image_t *F=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de variância
   float_image_t *G=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de intervalos menores
   float_image_t *H=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de intervalos maiores
   variancia[1]=0.0;
   for (i=0;i<I->sz[1];i+=k)
   {
	for (j=0;j<I->sz[2];j+=k)	
	{
		media=getMediaRegiao(I,i,i+k,j,j+k); //obtem a média da região               
		float_image_set_sample(D,0,y,x,media); //armazena a média
		getVarianciaRegiao(I,i,i+k,j,j+k,media,variancia);//obtem a variância da região
                float_image_set_sample(F,0,y,x,variancia[0]);//armazena a variância
                getInterMenorMaiorRegiao(I,cInter,i,i+k,j,j+k,intervalo);//obtem o menor e maior intervalo da região.
                if (cInter[1]>1)
                   cInter[1]=1;
                else if (cInter[0]<0)
                   cInter[0]=0;                
                float_image_set_sample(G,0,y,x,cInter[0]);//armazena o intervalo menor
                float_image_set_sample(H,0,y,x,cInter[1]);//armazena o intervalo maior
		x++;		
	}
        y++;
        x=0;
   }
   vet[0]=D;
   vet[1]=F;
   vet[2]=G;
   vet[3]=H;
   return variancia[1];
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//cálcula a redução da imagem baseada em média
float_image_t *calculaMedia(float_image_t *I,int k)
{
   int i=0,j=0,x=0,y=0;
   float media=0.0;
   //float_image_t *D=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de média
   for (i=0;i<I->sz[1];i+=k)
   {
	for (j=0;j<I->sz[2];j+=k)	
	{
		media=getMediaRegiao(I,i,i+k,j,j+k); //obtem a média da região               
		float_image_set_sample(I,0,y,x,media); //armazena a média		
		x++;		
	}
        y++;
        x=0;
   }
   //I=D;
   //free(D);
   I->sz[1]=I->sz[1]/k;
   I->sz[2]=I->sz[2]/k;
   return I;
}


//escala os pixels da imagem para o domínio 0..1
float_image_t *getImageEscalada(float_image_t *J,float vari)
{
   int i=0,j=0;   
   float valor=0;
   //float_image_t *I=float_image_new(1,J->sz[1],J->sz[2]);
   for (i=0;i<J->sz[1];i++)
     for (j=0;j<J->sz[2];j++)
     {         
         valor=float_image_get_sample(J,0,i,j);         
         valor=(valor*0.998047)/vari;
         float_image_set_sample(J,0,i,j,(1.0-valor));         
     }
   return J;
}

//cálcula a redução da imagem baseada em variância
float_image_t *calculaVariancia(float_image_t *I,float_image_t *J,int k)
{
   int i=0,j=0,x=0,y=0;
   float variancia[2];
   //float_image_t *F=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de variância
   variancia[1]=0.0;
   for (i=0;i<I->sz[1];i+=k)
   {
	for (j=0;j<I->sz[2];j+=k)	
	{		
		getVarianciaRegiao(I,i,i+k,j,j+k,float_image_get_sample(J,0,y,x),variancia);//obtem a variância da região
                float_image_set_sample(I,0,y,x,variancia[0]);//armazena a variância
                
		x++;		
	}
        y++;
        x=0;
   }
   I->sz[1]=I->sz[1]/k;
   I->sz[2]=I->sz[2]/k;
   I=getImageEscalada(I,variancia[1]);
   //I=F;
   //free(F);
   return I;
}


//identifica o menor intervalo de uma região
float getInterMenorRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float intervalo)
{
  int i=0,j=0;
  float menor=1,valor=0;
  for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
        valor=float_image_get_sample(I,0,i,j);
        if (menor>(valor-intervalo))
            menor=valor-intervalo;        
     }
     return menor;     
}

//identifica o maior intervalo de uma região
float getInterMaiorRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float intervalo)
{
  int i=0,j=0;
  float maior=0,valor=0;
  for (i=inil;i<fiml;i++)
     for (j=inic;j<fimc;j++)
     {
        valor=float_image_get_sample(I,0,i,j);
        if (maior<(valor+intervalo))
            maior=valor+intervalo;        
     }
     return maior;     
}

//cálcula a redução da imagem baseada em intervalos menores
float_image_t *calculaIntervaloLo(float_image_t *I,int k,float intervalo)
{
   int i=0,j=0,x=0,y=0;
   float valor=0.0;
   //float_image_t *G=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de intervalos menores     
   for (i=0;i<I->sz[1];i+=k)
   {
	for (j=0;j<I->sz[2];j+=k)	
	{		
                valor=getInterMenorRegiao(I,i,i+k,j,j+k,intervalo);//obtem o menor intervalo da região.                
                if (valor<0)
                   valor=0;                
                float_image_set_sample(I,0,y,x,valor);//armazena o intervalo menor
		x++;		
	}
        y++;
        x=0;
   }
   //I=G;
   //free(G);
   I->sz[1]=I->sz[1]/k;
   I->sz[2]=I->sz[2]/k;
   return I;
}

//cálcula a redução da imagem baseada em intervalos maiores
float_image_t *calculaIntervaloHi(float_image_t *I,int k,float intervalo)
{
   int i=0,j=0,x=0,y=0;
   float valor=0.0;
   //float_image_t *H=float_image_new(1,I->sz[1]/k,I->sz[2]/k);//imagem de intervalos menores     
   for (i=0;i<I->sz[1];i+=k)
   {
	for (j=0;j<I->sz[2];j+=k)	
	{		
                valor=getInterMaiorRegiao(I,i,i+k,j,j+k,intervalo);//obtem o menor e maior intervalo da região.                
                if (valor>1)
                   valor=1;                
                float_image_set_sample(I,0,y,x,valor);//armazena o intervalo menor
		x++;		
	}
        y++;
        x=0;
   }
   //I=H;
   //free(H);
   I->sz[1]=I->sz[1]/k;
   I->sz[2]=I->sz[2]/k;
   return I;
}

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/*int main(int argc, char** argv)
{
  float_image_t *vet[4];
  
  int i=0;
  float mVari=0.0;

  FILE *arq;
  arq = fopen("teste5.ppm","rw");
  float_image_t *A = ex_read_image(arq, "teste5.ppm");

  A=getImageLuminosidade(A);  
  
  mVari=calculaMediaVarianciaIntervalos(A,vet,2,0.01);
  vet[1]=getImageEscalada(vet[1],mVari);

  ex_write_image(NULL,"reduzMedia.ppm",vet[0]);
  ex_write_image(NULL,"reduzVariancia.ppm",vet[1]);  
  ex_write_image(NULL,"reduzInterMenor.ppm",vet[2]);
  ex_write_image(NULL,"reduzInterMaior.ppm",vet[3]);

  return 0;
}*/
