#ifndef reducao
#define reducao

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 

//realiza a conversão para tons de cinza
float_image_t *getImageLuminosidade(float_image_t *I);

//Média Aritmética da Região
float getMediaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc);

//Variancia da Região retornada em vet[0] e o maior valor em vet[1]
void getVarianciaRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float m,float vet[2]);

//identifica o maior e o menor intervalo de uma região, sendo o menor em vet[0] e o maior em vet[1]
void getInterMenorMaiorRegiao(float_image_t *I,float vet[2],int inil,int fiml,int inic,int fimc,float intervalo);

//realiza o cálculo da média (vet[0]), variancia (vet[1]), baixos intervalos (vet[2]) e altos intervalos (vet[3])
float calculaMediaVarianciaIntervalos(float_image_t *I,float_image_t *vet[4],int k,float intervalo);

//escala os pixels da imagem para o domínio 0..1
float_image_t *getImageEscalada(float_image_t *J,float vari);

//cálcula a redução da imagem baseada em média
float_image_t *calculaMedia(float_image_t *I,int k);

//cálcula a redução da imagem baseada em variância
float_image_t *calculaVariancia(float_image_t *I,float_image_t *J,int k);

//cálcula a redução da imagem baseada em intervalos menores
float_image_t *calculaIntervaloLo(float_image_t *I,int k,float intervalo);

//cálcula a redução da imagem baseada em intervalos maiores
float_image_t *calculaIntervaloHi(float_image_t *I,int k,float intervalo);

float getInterMenorRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float intervalo);
float getInterMaiorRegiao(float_image_t *I,int inil,int fiml,int inic,int fimc,float intervalo);

#endif
