#define _GNU_SOURCE
#include <stdio.h>

#include <sementes.h>


image_brilho *obtemSementesFundo(float_image_t *img)
{
   int i;
   float R=float_image_get_sample(img,0,3,3);
   float G=float_image_get_sample(img,1,3,3);
   float B=float_image_get_sample(img,2,3,3);
   double brilho=calculaBrilho(R,G,B);
   image_brilho *l=criaNo(brilho,0,0), *novo=NULL;
   int x=img->sz[1]-10,y=img->sz[2]-10;
   R=float_image_get_sample(img,0,y,3);
   G=float_image_get_sample(img,1,y,3);
   B=float_image_get_sample(img,2,y,3);
   brilho=calculaBrilho(R,G,B);
   novo=criaNo(brilho,y,3);
   novo->prox=l;
   l=novo;
   for (i=1;i<img->sz[1];i++)
   {
      R=float_image_get_sample(img,0,i,0);
      G=float_image_get_sample(img,1,i,0);
      B=float_image_get_sample(img,2,i,0);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,i,0);
      novo->prox=l;
      l=novo;

      R=float_image_get_sample(img,0,i,1);
      G=float_image_get_sample(img,1,i,1);
      B=float_image_get_sample(img,2,i,1);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,i,1);
      novo->prox=l;
      l=novo;

//+++++++++++++

      R=float_image_get_sample(img,0,i,y);
      G=float_image_get_sample(img,1,i,y);
      B=float_image_get_sample(img,2,i,y);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,i,y);
      novo->prox=l;
      l=novo;

      R=float_image_get_sample(img,0,i,y-1);
      G=float_image_get_sample(img,1,i,y-1);
      B=float_image_get_sample(img,2,i,y-1);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,i,y-1);
      novo->prox=l;
      l=novo;
   }
   for (i=1;i<img->sz[2];i++)
   {
      R=float_image_get_sample(img,0,3,i);
      G=float_image_get_sample(img,1,3,i);
      B=float_image_get_sample(img,2,3,i);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,0,i);
      novo->prox=l;
      l=novo;

      R=float_image_get_sample(img,0,4,i);
      G=float_image_get_sample(img,1,4,i);
      B=float_image_get_sample(img,2,4,i);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,1,i);
      novo->prox=l;
      l=novo;

//+++++++++++++

      R=float_image_get_sample(img,0,x,i);
      G=float_image_get_sample(img,1,x,i);
      B=float_image_get_sample(img,2,x,i);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,x,i);
      novo->prox=l;
      l=novo;

      R=float_image_get_sample(img,0,x-1,i);
      G=float_image_get_sample(img,1,x-1,i);
      B=float_image_get_sample(img,2,x-1,i);
      brilho=calculaBrilho(R,G,B);
      novo=criaNo(brilho,x-1,i);
      novo->prox=l;
      l=novo;
   }
   return l;
}

image_brilho *obtemSementesObjeto(image_brilho *list,int pos)
{
   int i;
   image_brilho *aux=list,*l=NULL,*novo=NULL;
   for (i=0;i<pos;i++)
      aux=aux->prox;
   l=criaNo(aux->brilho,aux->x,aux->y);
   while(aux!=NULL)
   {
      novo=criaNo(aux->brilho,aux->x,aux->y);
      novo->prox=l;
      l=novo;
      aux=aux->prox;
   }
   return l;
}


void gravaSementesArquivo(image_brilho *Obj,image_brilho *Fun,char *name_arq,int ny)
{
    char *linha=NULL;
    char *nome=NULL;
    asprintf(&nome,"Seeds/%s.txt",name_arq);
    FILE *arq=fopen(nome,"w");

    //fputs("X Y C\n",arq);

    while (Obj!=NULL)
    {
        asprintf(&linha,"( %d %d ) = %d \n",Obj->x,ny-Obj->y,1); //!!! o eixo y esta invertido
        fputs(linha,arq);
        Obj=Obj->prox;
    }
    while (Fun!=NULL)
    {
        asprintf(&linha,"( %d %d ) = %d \n",Fun->x,ny-Fun->y,2);//!!! o eixo y esta invertido
        fputs(linha,arq);
        Fun=Fun->prox;
    }
    fclose(arq);
    free(nome);
    free(linha);
}


void obterSementes(char *filename,char *name,float percent,int repetido)
{
    int pos=0;
    image_brilho *list=NULL;
    float_image_t *img=getImageOpenRGB(filename);
    int fim[2];
    int ny=(img->sz[2]-1);
    fim[0]=(img->sz[1]*img->sz[2]);

    list=calculaListaBrilho(list,img,repetido,fim);
    //exibeLista(list);

    pos=(int)(fim[2]*(1-percent));

    image_brilho *Obj=obtemSementesObjeto(list,pos);

    image_brilho *Fun=obtemSementesFundo(img);
    
    gravaSementesArquivo(Obj,Fun,name,ny);

    float_image_free(img);
    free_ListaBrilho(list);
    free_ListaBrilho(Obj);
    free_ListaBrilho(Fun);
}


int main(int argc, char** argv)
{
    void *trash = malloc(1);
  struct mallinfo info;
  int MemDinInicial, MemDinFinal;
  free(trash);
  info = mallinfo();
  MemDinInicial = info.uordblks;

  //começa aqui
  int repetido=1;
  if (strcmp(argv[4],"TRUE")==0) 
     repetido=1;
  else if (strcmp(argv[4],"FALSE")==0)
     repetido=0;

  obterSementes(argv[1],argv[2],atof(argv[3]),repetido);

  //termina aqui

  info = mallinfo();
  MemDinFinal = info.uordblks;
  //if (MemDinInicial!=MemDinFinal)
   // printf("\n\nMain loop: Dinamic memory was not completely deallocated (%d, %d)\n", MemDinInicial,MemDinFinal);

  return 1;
}
