#ifndef estimaDistancia_a_H
#define estimaDistancia_a_H

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <bool.h>        
#include <float_image.h> 

typedef float_image_t img_t;

float dLoMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd,int bgZero,int usa_IA,int usa_MD_SD);
float dHiMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd,int bgZero,int usa_IA,int usa_MD_SD);
float dMdMono(double aLo,double aHi,double aMd,double aSd, double bLo,double bHi,double bMd,double bSd,int bgZero,int usa_IA,int usa_MD_SD);
// Estas funcoes calculam o limite inferior, limite superior, e valor esperado (no sentido rms)
// da distancia euclidiana entre duas sub-imagens monocromaticas {A,B},
// dados os valores mínimos {aLo,bLo}, valores maximos {aHi,bHi}, valores médios {aMd,bMd}, e
// desvios {aSd,bSd} dos pixels de {A} e {B}. 
// Se {bgZero} eh 1, trata valor 0 como fundo.


typedef enum {
  QDIST_EURGB = 0,     // Distância euclidiana no espaço RGB.
  QDIST_EUGRADYUV = 1  // Distância euclidiana do gradiente normalizado no espaço YUV.
} QDIST_t;

double calculaLambda(int cumul,int res,int res_max,double base);
//Calcula o peso {lambda} a ser atribuído à distância de imagens na escala {res}
//  no cálculo da distância total.
//  Se {cumul} é 0, a distância total é apenas a distância na escala 0.
//  Se {cumul} é 1, a distância total é a soma das distâncias em cada escala {res},
//    com peso proporcional a {base^res}.
//Os lambdas são normalizados de modo a somar 1 para {res} variando de 0 a {res_max} inclusive.

// ESTIMADORES DE DISTÂNCIA DE IMAGENS




float calcula_dist_EURGB
( img_t *Amd,
    img_t *Bmd,
    int bgZero
);


// As funções nesta seção calculam o limite inferior {dist[0]}, limite superior {dist[1]}, e valor
// esperado (no sentido rms)
// {dist[2]} da distancia euclidiana entre duas imagens {A,B},
// dadas as imagens com os valores mínimos {aLo,bLo}, valores maximos {aHi,bHi}, valores médios {aMd,bMd}, e
// desvios {aSd,bSd} dos pixels de {A} e {B}, em uma escala {res} qualquer entre 0 e {res_max}. 
// Se {bgZero} eh 1, trata valor 0 como fundo.
// Se {usa_IA} eh 1, utiliza aritmética intervalar
// Se {usa_MD_SD} eh 1, utiliza média e desvio-padrão
// Se {usa_IA} e {usa_MD_SD} são 1, então utiliza aritmética intervalar porém ajusta se necessário com média e desvio-padão

void estima_dist_EURGB
  ( img_t *Alo, 
    img_t *Ahi,
    img_t *Amd,
    img_t *ASd, 
    img_t *Blo,
    img_t *Bhi,
    img_t *Bmd,
    img_t *BSd,
    int res, 
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[] // Saída
  );
// Calcula estimativas para a distância euclidiana simples na escala 0, usando as imagens na escala {res}.

void estima_dist_EURGB_MultiScale
(
    img_t *Alo, 
    img_t *Ahi,
    img_t *Amd,
    img_t *Asd, 
    img_t *Blo,
    img_t *Bhi,
    img_t *Bmd,
    img_t *Bsd,
    int res,
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float *distAcc,
    double lambda[],
    float dist[] // Saída
);
// Calcula estimativas para a distância euclidiana multi-escala, ponderada com pesos {lambda[0..res_max]}.
// Supõe que {distAcc} contém a soma das distâncias (exatas) ponderadas e acumuladas para as escalas
// {res+1..res_max}, e que as imagens dadas são as versões na escala {res}.

void estima_dist_EUGRADYUV_MultiScale
(
    img_t *Alo, 
    img_t *Ahi,
    img_t *Amd,
    img_t *Asd, 
    img_t *Blo,
    img_t *Bhi,
    img_t *Bmd,
    img_t *Bsd,
    int res,
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float *distAcc,
    double lambda[],
    float dist[]
);
// Calcula estimativas para a distância euclidiana de gradientes multi-escala no espaço YUV,
// ponderada com pesos {lambda[0..res_max]}.
// Supõe que {distAcc} contém a soma das distâncias (exatas) ponderadas para as escalas {res+1..res_max},
// e que as imagens dadas são as versões na escala {res}.

#endif
