#include <operacoes_a.h>
#include <calculoComparacao.h>
#include <assert.h>


float_image_t *ex_read_image(FILE *rd, char *name, sign_t round_dir)
  { bool_t close_it = FALSE;
    if (rd == NULL) { rd = open_read(name, TRUE); close_it = TRUE; }
    pnm_image_t *pim = pnm_image_fread(rd);
    float_image_t *fim = ex_float_image_from_pnm_image(pim, round_dir, FALSE);
    pnm_image_free(pim);
    if (close_it) { fclose(rd); }
    return fim;
  }

void ex_write_image(FILE *wr, char *name, float_image_t *img)
  { bool_t close_it = FALSE;
    if (wr == NULL) { wr = open_write(name, FALSE); close_it = TRUE; }
    pnm_image_t *pim = ex_float_image_to_pnm_image(img, 255 ,FALSE);
    pnm_image_fwrite(wr, pim, FALSE);
    if (close_it) { fclose(wr); }
    pnm_image_free(pim);
  }

float_image_t *getImageOpenRGB(char *name, sign_t round_dir)
{
   if (strlen(name)>=1)
   {
      FILE *arq;
      arq = fopen(name,"rw");
      if (arq == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", name); assert(0); }
      float_image_t *I = ex_read_image(arq, name, round_dir);
      fclose(arq);
      if (I==NULL)
      {
         fprintf(stderr, "Não foi possível abrir o arquivo.\n");
      }
      return I;
   }
   return NULL;
}

void leImagens(char *bandir,char *nome,int res,char *ext,float_image_t **HI,float_image_t **LO,float_image_t **MD,float_image_t **SD)
{
  char *filename=NULL;
  if (res>0)
  {
    asprintf(&filename,"%s/%s/Hi/R%02d.%s",bandir,nome,res,ext);
    *HI = getImageOpenRGB(filename,POS);
    asprintf(&filename,"%s/%s/Lo/R%02d.%s",bandir,nome,res,ext);
    *LO = getImageOpenRGB(filename,NEG);
    asprintf(&filename,"%s/%s/Md/R%02d.%s",bandir,nome,res,ext);
    *MD = getImageOpenRGB(filename,ZER);
    asprintf(&filename,"%s/%s/Sd/R%02d.%s",bandir,nome,res,ext);
    *SD = getImageOpenRGB(filename,POS);
  }
  else
  {
    asprintf(&filename,"%s/%s/Md/R%02d.%s",bandir,nome,res,ext);
    *MD = getImageOpenRGB(filename,ZER);
    *HI = *MD;
    *LO = *MD;
    *SD = NULL;
  }
  free(filename);
  assert(HI !=NULL);
  assert(LO !=NULL);
  assert(MD !=NULL);
  assert(SD !=NULL);
}

void liberaImagens(float_image_t **HI,float_image_t **LO,float_image_t **MD,float_image_t **SD)
{
    if ((*HI!=NULL)&&(*HI!=*LO)&&(*HI!=*MD)){float_image_free(*HI);}
    if ((*LO!=NULL)&&(*LO!=*MD)){float_image_free(*LO);}
    if (*MD!=NULL){float_image_free(*MD);}
    if (*SD!=NULL){float_image_free(*SD);}
    *HI=NULL;
    *LO=NULL;
    *MD=NULL;
    *SD=NULL;
}

float_image_t *ex_float_image_from_pnm_image
  ( pnm_image_t *iim, 
    sign_t round_dir, 
    bool_t verbose
  )
  { 
    /* Get image dimensions: */
    int NX = iim->cols;
    int NY = iim->rows;
    
    /* Channel counts: */
    int chns = iim->chns; /* Num of channels. */
    
    /* Allocate float image: */
    float_image_t *fim = float_image_new(chns, NX, NY);
    
    /* Max sample value in integer image: */
    pnm_sample_t maxval = iim->maxval;
    
    /* Input and output range registers: */
    sample_uint_t imin[chns], imax[chns]; /* Input range registers. */ 
    float vmin[chns], vmax[chns];         /* Output range registers. */ 
    int c; /* Channel index. */
    for (c = 0; c < chns; c++) 
      { imin[c] = maxval;
        imax[c] = 0;
        vmin[c] = +INF;
        vmax[c] = -INF;
      }
    
    /* Convert pixels, keep statistics: */
    int x, y;
    for(y = 0; y < NY; y++)
      { int pgmy = NY - 1 - y;
        pnm_sample_t *prow = iim->smp[pgmy];
        for(x = 0; x < NX; x++)
          { for (c = 0; c < chns; c++)
              { /* Convert int sample {*prow} to float {v}, store, keep stats: */
                pnm_sample_t ismp = (*prow);
                float fsmp = ex_sample_conv_floatize
                  ( ismp, maxval, round_dir, &(imin[c]), &(imax[c]), &(vmin[c]), &(vmax[c]) );
                float_image_set_sample(fim, c, x, y, fsmp);
                prow++;
              }
          }
      }
    
    if (verbose) 
      { /* Print statistics: */
        long int NPIX = ((long int)NX)*((long int)NY);
        fprintf(stderr, "  %ld pixels in PNM image\n", NPIX);
        if (NPIX > 0)
          { for (c = 0; c < chns; c++)
              { double loc = 0.0;
                double hic = 1.0;
                sample_conv_print_floatize_stats
                  ( c, c, imin[c], imax[c], maxval, loc, hic, vmin[c], vmax[c] );
              }
          }
      }
    
    return fim;
  }

float ex_sample_conv_floatize
  ( sample_uint_t iv, 
    sample_uint_t maxval,
    sign_t round_dir,
    sample_uint_t *imin, 
    sample_uint_t *imax, 
    float *vmin,
    float *vmax
  )
  /* Convert integer intensity to float, kep stats: */
  { if ((imin != NULL) && (iv < (*imin))) { (*imin) = iv; }
    if ((imax != NULL) && (iv > (*imax))) { (*imax) = iv; }
    /* Convert integer {iv} to double {rv} accounting for quantization error in writing: */
    double rv;
    if (iv == 0)
      { rv = 0.0; }
    else
      { rv = ((double)iv - 0.5 + 0.5*round_dir)/((double)maxval); }
    /* Convert {rv} to float {fv} and adjust to account for arithmetic rounding errors: */
    float fv = rv + 1.0e-6*round_dir;
    if ((iv != 0) && (fv <= 0)) { fv = 1.0e-100; }
    if (fv > 1.0) { fv = 1.0; }
    if ((vmin != NULL) && (fv < (*vmin))) { (*vmin) = fv; }
    if ((vmax != NULL) && (fv > (*vmax))) { (*vmax) = fv; }
    return fv;
  }

sample_uint_t ex_sample_conv_quantize
  ( float fv, 
    sample_uint_t maxval,
    float *vmin,
    float *vmax, 
    int *clo,
    int *chi,
    sample_uint_t *imin, 
    sample_uint_t *imax
  )
  { demand(! isnan(fv), "{fv} is NaN"); 
    if ((vmin != NULL) && (fv < (*vmin))) { (*vmin) = fv; }
    if ((vmax != NULL) && (fv > (*vmax))) { (*vmax) = fv; }

    if (fv < 0.0) { fv = 0.0;  if (clo != NULL) { (*clo)++; } }
    if (fv > 1.0) { fv = 1.0;  if (chi != NULL) { (*chi)++; } }
    sample_uint_t zv = (int)ceil(fv*maxval);
    demand((zv >= 0) && (zv <= (int)maxval), "bad {zv}");
    sample_uint_t iv = zv;
    if ((imin != NULL) && (iv < (*imin))) { (*imin) = iv; }
    if ((imax != NULL) && (iv > (*imax))) { (*imax) = iv; }
    return iv;
  }

pnm_image_t *ex_float_image_to_pnm_image
  ( float_image_t *fim, 
    sample_uint_t maxval,
    bool_t verbose
  )
  { /* Get image dimensions: */
    int NC = fim->sz[0];
    int NX = fim->sz[1];
    int NY = fim->sz[2];
    
    /* Channel counts: */
    int fchns = NC; /* Num channels in float image. */
    int ichns = NC; /* Num channels in integer image. */
    int chns = NC;
    /* Allocate PGM/PPM image: */
    pnm_image_t *iim = pnm_image_new(NX, NY, ichns);
    
    /* Set max sample value in integer image: */
    iim->maxval = maxval;
    
    /* Channel indexing variables: */
    int k; /* Channel of integer image. */
    int c; /* Channel of float image. */
    
    /* Input and output range registers: */
    float vmin[ichns], vmax[ichns];         /* Float pixel range. */
    sample_uint_t imin[ichns], imax[ichns]; /* Int pixel range. */
    int clo[ichns], chi[ichns];             /* Counts of lo-clipped and hi-clipped pixels. */
    for (k = 0; k < ichns; k++) 
      { clo[k] = chi[k] = 0;
        vmin[k] = +INF;
        vmax[k] = -INF; 
        imin[k] = maxval;
        imax[k] = 0;  
      }
    
    /* Convert pixels, store in {iim}, keep statistics: */
    int x, y;
    for(y = 0; y < NY; y++)
      { int ppmy = NY-1-y;
        pnm_sample_t *prow = iim->smp[ppmy];
        for(x = 0; x < NX; x++)
          { /* Convert float pixel {fpxy[c..c+2]} to integer pixel {ipxy[0..2]}, keep stats: */
            for (k = 0; k < ichns; k++)
              { c = k;
                float v = ((c < 0) || (c >= fchns) ? 0.0 : float_image_get_sample(fim, c, x, y));
                (*prow) = ex_sample_conv_quantize
                  ( v, maxval, 
                    &(vmin[k]), &(vmax[k]), &(clo[k]), &(chi[k]), &(imin[k]), &(imax[k])
                  );
                prow++;
              }
          }
      }
    
    if (verbose)
      { /* Print statistics: */
        long int NPIX = ((long int)NX)*((long int)NY);
        fprintf(stderr, "  %ld pixels in float image\n", NPIX);
        if (NPIX > 0)
          { for (k = 0; k < chns; k++)
              { double lok = 0.0;
                double hik = 1.0;
                c = k;
                sample_conv_print_quantize_stats
                  ( c, k, vmin[k], vmax[k], lok, hik, clo[k], chi[k], maxval, imin[k], imax[k]);
              }
          }
      }
    
    return iim;
  }
