#ifndef operacoes_a_H
#define operacoes_a_H

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 
#include <malloc.h>
#include <sign.h>
#include <sample_conv.h>

//includes referentes a partes do programa implementadas
//#include <calculoComparacao.h>
//++++++++++++++++++++++++++++++++++++++++++++++++++++++

float_image_t *ex_read_image(FILE *rd, char *name, sign_t round_dir);

void ex_write_image(FILE *wr, char *name, float_image_t *img);

float_image_t *getImageOpenRGB(char *name, sign_t round_dir);

void leImagens(char *bandir,char *nome,int res,char *ext,float_image_t **HI,float_image_t **LO,float_image_t **MD,float_image_t **SD);
//Se escala igual a zero devolve *LO=*HI=*MD, e *SD=NULL significando imagem de zeros

void liberaImagens(float_image_t **HI,float_image_t **LO,float_image_t **MD,float_image_t **SD);
//função toma cuidado caso algumas das imagens sejam NULL ou identicas a outras das imagens

float_image_t *ex_float_image_from_pnm_image( pnm_image_t *iim, sign_t round_dir, bool_t verbose);

float ex_sample_conv_floatize(sample_uint_t iv,sample_uint_t maxval,sign_t round_dir,sample_uint_t *imin,sample_uint_t *imax,float *vmin,float *vmax);

sample_uint_t ex_sample_conv_quantize(float fv,sample_uint_t maxval,float *vmin,float *vmax,int *clo,int *chi,sample_uint_t *imin,sample_uint_t *imax);

pnm_image_t *ex_float_image_to_pnm_image(float_image_t *fim,sample_uint_t maxval,bool_t verbose);



#endif
