#include <reduzbanco.h>
#include <sys/stat.h>
#include <sign.h>

int main(int argc, char** argv)
{
  char *bandir = argv[1];
  char *nome = argv[2];
  int resMax = atoi(argv[3]);
  int fator = atoi(argv[4]);
  bool_t ignorazero = atoi(argv[5]);
  bool_t cinza = TRUE;
  bool_t testa = FALSE;

  fprintf(stderr, "\n+++++++++++++++++++++++++++++++INICIO++++++++++++++++++++++++++++++++++++++\n");
  fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

  fprintf(stderr, "parametros:\n");
  fprintf(stderr, "diretório do banco = %s\n", bandir);
  fprintf(stderr, "escala de reducão máxima da imagem (0 = original) = %d\n", resMax);
  fprintf(stderr, "fator de redução das imagens = %d\n", fator);
  fprintf(stderr, "nome (número) da imagem a reduzir = %s\n", nome);
  fprintf(stderr, "valor zero significa fundo = %d\n", ignorazero);
  fprintf(stderr, "grava versão cinza = %d\n", cinza);
  fprintf(stderr, "testa reducao incremental = %d\n", testa);

  calculaPiramide(bandir,nome,resMax,fator,ignorazero,cinza,testa);
  fprintf(stderr, "\n++++++++++++++++++++++++++++++++++FIM++++++++++++++++++++++++++++++++++++++\n");
  fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");

  //free(bandir);
  //free(nome);
  return 0;
}

void calculaPiramide(char *dir,char *nome,int resMax,int fatorReducao,bool_t ignorazero,bool_t cinza,bool_t testa)
{
  char *filename=NULL;
  asprintf(&filename,"%s/%s/norm.ppm",dir,nome);
  float_image_t *I=getImageOpenRGB(filename,ZER);
  
  assert(I->sz[0] == 3);
  calculaPiramideDaImagem(I,nome,resMax,fatorReducao,dir,ignorazero);
  if (testa) { testaPiramideDaImagem(I,resMax,fatorReducao,ignorazero); }
  if (cinza) 
    { float_image_t *Y = getImageLuminosidade(I);
      calculaPiramideDaImagem(Y,nome,resMax,fatorReducao,dir,ignorazero);
      if (testa) { testaPiramideDaImagem(Y,resMax,fatorReducao,ignorazero); }
      float_image_free(Y);
    }
  free(filename);
  float_image_free(I);
}

void escreveImagemTipoEscala(float_image_t *I,char *dir,char *nome,char *tipo,int res)
{
  char *filename=NULL;
  char *ext = (I->sz[0] == 1 ? "pgm" : "ppm");
  asprintf(&filename,"%s/%s/%s/R%02d.%s",dir,nome,tipo,res,ext);
  ex_write_image(NULL,filename,I);
  free(filename);
}

//realiza a redução (RGB ou cinza) em um fator determinado por parametro
void calculaPiramideDaImagem(float_image_t *I,char *nome,int resMax,int fatorReducao,char *dir,bool_t ignorazero)
{
  assert(ignorazero == 0); // Media e variancia nao funcionam com ignorazero=1.

  int res=0;

  char *kind[4] = { "Md", "Sd", "Lo", "Hi" };
  int ik;
  for (ik = 0; ik < 4; ik++ )
    {	char *outdirname=NULL;
      asprintf(&outdirname,"%s/%s/%s",dir,nome,kind[ik]);
      mkdir(outdirname, S_IRWXU+S_IXGRP+S_IXOTH);
      free(outdirname);
    }

  float_image_t *Md=float_image_copy(I);
  float_image_t *Vr=float_image_copy(I);
  float_image_fill(Vr, 0.0);
  float_image_t *Lo=float_image_copy(I);
  float_image_t *Hi=float_image_copy(I);
  while (1)
    {
      escreveImagemTipoEscala(Md,dir,nome,"Md",res);
      float_image_t *Sd = calculaDesvioPadrao(Vr);
      escreveImagemTipoEscala(Sd,dir,nome,"Sd",res);
      float_image_free(Sd);
      escreveImagemTipoEscala(Lo,dir,nome,"Lo",res);
      escreveImagemTipoEscala(Hi,dir,nome,"Hi",res);
      res++;
      if (res>resMax) break;
      calculaMediaVarianciaRGB(Md,Vr,fatorReducao);
      calculaIntervaloLoRGB(Lo,fatorReducao,0.0,ignorazero);
      calculaIntervaloHiRGB(Hi,fatorReducao,0.0,ignorazero);
    }
  float_image_free(Md);
  float_image_free(Vr);
  float_image_free(Lo);
  float_image_free(Hi);
}

void testaPiramideDaImagem(float_image_t *I,int resMax,int fatorReducao,bool_t ignorazero)
{

  int res=0;
  int fatorTotal = 1;

  float_image_t *MdP=float_image_copy(I);
  float_image_t *VrP=float_image_copy(I);
  float_image_fill(VrP, 0.0);
  float_image_t *LoP=float_image_copy(I);
  float_image_t *HiP=float_image_copy(I);
  while (1)
    {
      res++;
      fatorTotal *= fatorReducao;
      if (res>resMax) break;
      // Reducao passo a passo:
      calculaMediaVarianciaRGB(MdP,VrP,fatorReducao);
      calculaIntervaloLoRGB(LoP,fatorReducao,0.0,ignorazero);
      calculaIntervaloHiRGB(HiP,fatorReducao,0.0,ignorazero);

      // Reducao de uma so vez:
      float_image_t *MdT=float_image_copy(I);
      float_image_t *VrT=float_image_copy(I);
      float_image_fill(VrT, 0.0);
      float_image_t *LoT=float_image_copy(I);
      float_image_t *HiT=float_image_copy(I);
      calculaMediaVarianciaRGB(MdT,VrT,fatorTotal);
      calculaIntervaloLoRGB(LoT,fatorTotal,0.0,ignorazero);
      calculaIntervaloHiRGB(HiT,fatorTotal,0.0,ignorazero);

      // Compara as duas versoes:
      double eMd = 0, eVr = 0, eLo = 0, eHi = 0;
      int i, j, c;
      for (i = 0; i < MdT->sz[1]; i++)
        for (j = 0; j < MdT->sz[2]; j++)
          for (c = 0; c < MdT->sz[0]; c++)
            { double dMd = float_image_get_sample(MdT,c,i,j) - float_image_get_sample(MdP,c,i,j);
              double dVr = float_image_get_sample(VrT,c,i,j) - float_image_get_sample(VrP,c,i,j);
              double dLo = float_image_get_sample(LoT,c,i,j) - float_image_get_sample(LoP,c,i,j);
              double dHi = float_image_get_sample(HiT,c,i,j) - float_image_get_sample(HiP,c,i,j);
              if (fabs(dMd) > fabs(eMd)) { eMd = dMd; }
              if (fabs(dVr) > fabs(eVr)) { eVr = dVr; }
              if (fabs(dLo) > fabs(eLo)) { eLo = dLo; }
              if (fabs(dHi) > fabs(eHi)) { eHi = dHi; }
            }
      fprintf(stderr, "max error Md = %+12.7f\n", eMd); assert(fabs(eMd) < 0.0001);
      fprintf(stderr, "max error Vr = %+12.7f\n", eVr); assert(fabs(eVr) < 0.0001);
      fprintf(stderr, "max error Lo = %+12.7f\n", eLo); assert(fabs(eLo) < 0.0001);
      fprintf(stderr, "max error Hi = %+12.7f\n", eHi); assert(fabs(eHi) < 0.0001);

      float_image_free(MdT);
      float_image_free(VrT);
      float_image_free(LoT);
      float_image_free(HiT);
    }
  float_image_free(MdP);
  float_image_free(VrP);
  float_image_free(LoP);
  float_image_free(HiP);
}
