/* Last edited on 2009-12-14 01:01:17 by stolfilocal */
#include <buscaBruta.h>
#include <assert.h>
#include <sign.h>

#define True 1
#define False 0

// PROTOTIPOS INTERNOS

void gravaResultados(char *bandir, char *model_name, int nMin, float distMin[], char *nomeMin[]);

// IMPLEMENTACOES

void buscaBruta(
  char *bandir,
  char *model_name,
  char *ext,
  int res_max,
  int fator,
  int num_imagens,
  char *nome_imagem[],
  int num_resultados,
  int distsExPorNivel[],
  int bgZero,
  QDIST_t qualDist,
  int cumul,
  double base
)
{
  int debug = 0;
  
  int nMin = 0; /* Numero de melhores resultados guardados. */
  float distMin[num_resultados]; /* Distancias desses melhores resultados. */
  char *nomeMin[num_resultados]; /* Nomes desses melhores resultados. */

  // Piramide da imagem modelo
  float_image_t *modeloMdlo[res_max+1];
  int i;
  for (i=0; i <= res_max; i++)
    {      
      float_image_t *AMdlo=NULL;
      leImagens(bandir,model_name,i,ext,NULL, NULL,&AMdlo,NULL,NULL,NULL);
      modeloMdlo[i]=AMdlo;
    }

  // Cria lista de lambdas
  double lambda[res_max+1];
  for (i=0;i<=res_max;i++)
  {
    lambda[i]=calculaLambda(cumul,i,res_max,base);
    if (debug){
    fprintf(stderr, "Lambda[%d] = %10.7f\n", i, lambda[i]);}
  }

  for (i = 0; i < num_imagens; i++)
   {  
     char *cand_nome = nome_imagem[i];
     
     if (strcmp(cand_nome,model_name) == 0)
       { if (debug) { fprintf(stderr, "Excluindo a imagem %s\n", cand_nome); } } 
        
     else
       { 
         // Calcula distancia do candidato:
         float dist;
         if (cumul)
           { int res = res_max;
             float distAcc = 0.0;
             while (res >= 0)
               { /* Acumula o termo {res} da distancia: */
                 float_image_t *BMdlo=NULL;
                 leImagens(bandir,cand_nome,res,ext,NULL,NULL,&BMdlo,NULL,NULL,NULL);
                 acumula_dist_Multiescala(modeloMdlo[res],BMdlo,bgZero,qualDist,&distAcc,lambda[res],&(distsExPorNivel[res]));
                 float_image_free(BMdlo);
                 res--;
               }
             dist = distAcc;
           }
         else
           { /* Calcula distancia no nivel zero: */
             int res = 0;
             float_image_t *BMdlo=NULL;
             leImagens(bandir,cand_nome,res,ext,NULL,NULL,&BMdlo,NULL,NULL,NULL);
             dist = calcula_dist_Monoescala(modeloMdlo[res],BMdlo,bgZero,qualDist,&(distsExPorNivel[res]));
             float_image_free(BMdlo);
           }

         // Guarda se for o caso:
         int j = nMin;
         while ((j > 0) && (dist < distMin[j-1]))
           { /* Neste ponto {j >= num_resultados} ou {distMin[j] estah vago. */
             /* Tambem {dist} eh melhor que {distMin[j-1} e {distMin[j+1..]}. */
             if (j < num_resultados) 
               { distMin[j] = distMin[j-1]; nomeMin[j] = nomeMin[j-1]; }
             j--;
           }
         /* Se cabe na fila, guarda este candidato no seu lugar: */
         if (j < num_resultados) { distMin[j] = dist; nomeMin[j] = cand_nome; }
         /* Se havia menos de {num_resultados} candidatos, agora tem mais um: */
         if (nMin < num_resultados) { nMin++; }
       }
  }

  // Grava resultados
  gravaResultados(bandir,model_name,nMin,distMin,nomeMin);
  // Limpeza final
  for (i=0; i <= res_max; i++)
    { float_image_t *Amdlo=modeloMdlo[i];
      float_image_free(Amdlo);
    }
}

void gravaResultados(char *bandir, char *model_name, int nMin, float distMin[], char *nomeMin[])
{
  char *nomeArq=NULL;
  asprintf(&nomeArq,"%s/%s/resultado.txt",bandir,model_name);
  FILE *arq = fopen(nomeArq, "w");
  if (arq == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", nomeArq); assert(0); }
  free(nomeArq);
  int j;
  for (j = 0; j < nMin; j++)
    { char *nome = nomeMin[j];
      float dist = distMin[j];
      int res = 0;
      fprintf(arq,"%s %02d  %8.6f %8.6f %8.6f  %8.6f %8.6f\n",nome,res,dist,dist,dist,0.0,0.0);
    }
  fflush(arq);
}
