/* Last edited on 2009-12-13 23:26:30 by stolfilocal */
#ifndef buscaBruta_H
#define buscaBruta_H

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 
#include <malloc.h>

#include <estimaDistancia_b.h>

#include <operacoes_b.h>
#include <List.h>
#include <animacao.h>
#include <candidatos.h>

void buscaBruta
  ( char *bandir,
    char *model_name,
    char *ext,
    int res_max,
    int fator,
    int num_imagens,
    char *nome_imagem[],
    int num_resultados,
    int distsExPorNivel[],
    int bgZero,
    QDIST_t qualDist,
    int cumul,
    double base
  );
/* Faz a busca forca-bruta de uma imagem {model_name} na base {bandir}.
  As imagens sao "{bandir}/{nome}/{xx}/R{res}.{ext}"
  onde {nome} pode ser {model_name} (imagem de busca) ou {nome_imagem[i]}
  (imagem do banco), com {i} entre 0 e {num_imagens-1}. O campo {xx}
  pode ser "Lo", "Hi","Md", ou "Sd".
  
  Usa distancia {qualDist}.  Devolve as {num-resultados} melhores imagens. 
  Se {bgZero = 1} supoe que valor 0  fundo.
  
  Se {cumul}, usa distancia cumulativa com pesos proporcionais a {base^k} no nivel {k}.
  Supoe reducao por fator de escala {fator} ateh o nivel {resmax}.
  
  Incrementa {distsExPorNivel[k]} sempre que calcula uma distancia euclidiana
  entre imagens de nivel {k}.
  
  A resposta eh gravada no arquivo "{bandir}/{model_name}/resultado.txt".
  
  */
  

#endif
