#define _GNU_SOURCE
#include <stdio.h>
#include <calculaDistancia.h>
#include <operacoes_b.h>
#include <ia.h>

// Calcula uma estimativa de uma metrica dada entre duas imagens na escala original.
// A estimativa é calculada usando apenas as imagens de escalas {res..res_max}.
// Também calcula a distancia exata na mesma métrica e na escala original, e confere com a estimativa.
// Aceita monoescala e cumulativa.

//Protótipos
void calculaEstimativa(char *bandir,char *nameA,char *nameB,char *ext,int res,int res_max,int bgZero,int usa_IA,int usa_MD_SD,QDIST_t qualDist,int cumul,double lambda[],float dist[]);

float calculaExata(char *bandir,char *nameA,char *nameB,char *ext,int res_max,int bgZero,QDIST_t qualDist,int cumul,double lambda[]);


//Implementações

int main(int argc, char** argv)
{
  char *bandir=argv[1];
  char *nameA = argv[2];
  char *nameB = argv[3];
  char *ext = argv[4];
  int res = atoi(argv[5]);
  int res_max = atoi(argv[6]);
  char *arq_name = argv[7];
  int musis = atoi(argv[8]);
  int bgzero = atoi(argv[9]);
  int usa_IA = atoi(argv[10]);
  int usa_MD_SD = atoi(argv[11]);
  int qual = atoi(argv[12]);
  int cumul = atoi(argv[13]);
  float beta = atof(argv[14]);

  fprintf(stderr, "obs --- flag musis = %d ignorado\n", musis);

  fprintf(stdout, "nameA = %s\n", nameA);
  fprintf(stdout, "nameB = %s\n", nameB);
  double lambda[res_max+1];
  int i;
  for (i=0;i<=res_max;i++)
    { lambda[i]=calculaLambda(cumul,i,res_max,beta); }

  geraArqDistancias(bandir,nameA,nameB,arq_name,ext,res,res_max,bgzero,usa_IA,usa_MD_SD,qual,cumul,lambda);

  return 0;
}


float calculaExata(char *bandir,char *nameA,char *nameB,char *ext,int res_max,int bgZero,QDIST_t qualDist,int cumul,double lambda[])
{
  int k;
  float distAB=0;
  int ndistExP=0;
  fprintf(stderr, "calculo da distancia exata\n");

  for (k=(cumul?res_max:0);k>=0;k--)
    {
      char *name=NULL;
      asprintf(&name,"%s/%s/Md/R%02d.%s",bandir,nameA,k,ext);
      float_image_t *Ak=getImageOpenRGB(name,2);
      free(name);
      name=NULL;
      asprintf(&name,"%s/%s/Md/R%02d.%s",bandir,nameB,k,ext);
      float_image_t *Bk=getImageOpenRGB(name,2);
      free(name);
  
      float distkAB = calcula_dist_Monoescala
	(Ak,Bk,bgZero,qualDist,&ndistExP
	 );
      distAB+=distkAB*lambda[k];
      fprintf(stderr, "  k: %02d distkAB: %8.6f lambda: %8.6f distAB: %8.6f\n", k, distkAB, lambda[k], distAB);
      float_image_free(Ak);
      float_image_free(Bk);
    }
  return distAB;
}


void calculaEstimativa(char *bandir,char *nameA,char *nameB,char *ext,int res,int res_max,int bgZero,int usa_IA,int usa_MD_SD,QDIST_t qualDist,int cumul,double lambda[],float dist[])
{
  Interval distEstIA=(Interval){ 0.0, 1.0 };
  int ndistExP=0;
  int ndistIAP=0;

  float distAB=calculaExata(bandir,nameA,nameB,ext,res_max,bgZero,qualDist,cumul,lambda);

  fprintf(stderr, "calculo da estimativa na escala %02d\n", res);

  if (cumul)
    { 
      int k;
      float distAcc=0;
      for (k=res_max;k>=res;k--)
	{

          float_image_t *ALo=NULL;
          float_image_t *AHi=NULL;
          float_image_t *AMdLo=NULL;
          float_image_t *AMdHi=NULL;
          float_image_t *ASdLo=NULL;
          float_image_t *ASdHi=NULL;
          leImagens(bandir,nameA,k,ext,&ALo,&AHi,&AMdLo,&AMdHi,&ASdLo,&ASdHi);
          float_image_t *BLo=NULL;
          float_image_t *BHi=NULL;
          float_image_t *BMdLo=NULL;
          float_image_t *BMdHi=NULL;
          float_image_t *BSdLo=NULL;
          float_image_t *BSdHi=NULL;
          leImagens(bandir,nameB,k,ext,&BLo,&BHi,&BMdLo,&BMdHi,&BSdLo,&BSdHi);

          estima_dist_Multiescala
	    ( ALo, AHi, AMdLo, AMdHi, ASdLo, ASdHi,
	      BLo, BHi, BMdLo, BMdHi, BSdLo, BSdHi,
	      k, res_max, bgZero, usa_IA, usa_MD_SD, 
	      qualDist, &distAcc, lambda, dist, &distEstIA,
	      &ndistExP, &ndistIAP
	      );
          fprintf(stderr, "  k: %02d distAcc: %8.6f distEstIA: [%8.6f, %8.6f]\n", k, distAcc, distEstIA.lo,  distEstIA.hi);
	  liberaImagens(&ALo,&AHi,&AMdLo,&AMdHi,&ASdLo,&ASdHi);
	  liberaImagens(&BLo,&BHi,&BMdLo,&BMdHi,&BSdLo,&BSdHi);

	}
    }
  else
    { 

      float_image_t *ALo=NULL;
      float_image_t *AHi=NULL;
      float_image_t *AMdLo=NULL;
      float_image_t *AMdHi=NULL;
      float_image_t *ASdLo=NULL;
      float_image_t *ASdHi=NULL;
      leImagens(bandir,nameA,res,ext,&ALo,&AHi,&AMdLo,&AMdHi,&ASdLo,&ASdHi);
      float_image_t *BLo=NULL;
      float_image_t *BHi=NULL;
      float_image_t *BMdLo=NULL;
      float_image_t *BMdHi=NULL;
      float_image_t *BSdLo=NULL;
      float_image_t *BSdHi=NULL;
      leImagens(bandir,nameB,res,ext,&BLo,&BHi,&BMdLo,&BMdHi,&BSdLo,&BSdHi);

      estima_dist_Monoescala
	( ALo, AHi, AMdLo, AMdHi, ASdLo, ASdHi,
	  BLo, BHi, BMdLo, BMdHi, BSdLo, BSdHi,
	  res, res_max, bgZero, usa_IA, usa_MD_SD, 
	  qualDist, dist, 
	  &ndistExP, &ndistIAP
	);

      liberaImagens(&ALo,&AHi,&AMdLo,&AMdHi,&ASdLo,&ASdHi);
      liberaImagens(&BLo,&BHi,&BMdLo,&BMdHi,&BSdLo,&BSdHi);
    }
  
  fprintf(stderr,"Res: %d, dist: %8.6f, est: [%8.6f, %8.6f]\n",res,distAB,dist[0],dist[1]);

  if ((distAB<dist[0]) || (distAB>dist[1]))
    {
      assert(FALSE);
    }
}

void geraArqDistancias(char *bandir,char *nameA,char *nameB,char *arq_name,char *ext,int res,int res_max,int bgZero,int usa_IA,int usa_MD_SD,QDIST_t qualDist,int cumul,double lambda[])
{
  FILE *arq=fopen(arq_name,"w");
  if (arq == NULL) { fprintf(stderr, "** falhou abertura de '%s'\n", arq_name); assert(0); }
  float dist[3];


  calculaEstimativa(bandir,nameA,nameB,ext,res,res_max,bgZero,usa_IA,usa_MD_SD,qualDist,cumul,lambda,dist);
 
  fprintf(arq,"%d  %f  %f  %f\n",res,dist[0],dist[1],dist[2]);
  fclose(arq);
}
