/* Last edited on 2009-12-14 17:44:03 by stolfilocal */
#ifndef candidatos
#define candidatos

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>
#include <ia.h>

typedef enum {
  QFILA_Lo = 0, // Ordem crescente de d.lo, desempate por k decrescente.
  QFILA_Hi = 1, // Ordem crescente de d.hi, desempate por k decrescente.
  QFILA_Ex = 2, // Ordem de escolha para refinamento.
  QFILA_My = 3  // Ordem de escolha do usurio
} QFILA_t;

typedef struct candidato_t_{
  char *nome;		//nome da imagem
  int k;		//escala na qual as estimativas foram calculadas
  float distLo;		//limite inferior garantido para distancia.
  float distHi;	        //limite superior garantido para distancia.
  float distMd;         //uma estimativa para a distancia.
  // Estes campos sao usados apenas para distancia multiescala:
  float distAcc;        //distancia acumulada nas escalas {k..res_max}.
  Interval distEstIA;   //estimativa para a distancia {dist(Amdlo,Bmdlo)} no nivel {k-1}.

  // Listas de candidatos em varias ordens (QFILA_t):
  struct candidato_t_ *prox[3];	//proximo candidato
  struct candidato_t_ *ante[3];	//candidato anterior
}candidato_t;

typedef struct filaCandidatos_{
  int n;			//numero corrente de candidatos
  struct candidato_t_ *prim[3];	//primeiro candidato em ordem crescente em cada lista:
} filaCandidatos_t;

typedef int cmpCands_t(candidato_t *x,candidato_t *y);
// Tipo de uma rotina que compara candidatos, devolve -1 (x antes de y), 0, +1 

// Operacoes externas:

filaCandidatos_t criaFila(void);

candidato_t *insereCandidato
  ( filaCandidatos_t *fila,
    char *nome
    ,int escala,
    float distLo,
    float distHi,
    float distMd,
    float distAcc,
    Interval distEstIA,
    cmpCands_t *cmp
  );
// Insere o candidato nas tres filas. A funcao de comparacao {cmp} eh usada apenas na fila {QFILA_Ex}.

void reordenaFila(filaCandidatos_t *fila,cmpCands_t *cmp);
// Reordena a fila {QFILA_Ex} se necessario, usando a funcao de comparacao {cmp}.

candidato_t *buscaCandidato(filaCandidatos_t *fila,char *nome);

void retiraCandidato(filaCandidatos_t *fila,candidato_t *cand);

void freeFila(filaCandidatos_t *fila);


void exibeFila(filaCandidatos_t *fila,QFILA_t qual);

void exibeCand(candidato_t *cand);

candidato_t *indexaCand(filaCandidatos_t *fila,int i,QFILA_t qual);
// Devolve o candidato numero i (contando de 0) na fila, na ordem qual.
// Se nao houver, devolve NULL

// Operacoes internas:

int comparaLo(candidato_t *x,candidato_t *y);
// Ordem da fila {QFILA_Lo}: {distLo} crescente, desempate por {k} decrescente.

int comparaHi(candidato_t *x,candidato_t *y);
// Ordem da fila {QFILA_Hi}: {distHi} crescente, desempate por {k} decrescente.

candidato_t *novoCandidato
  ( char *nome,
    int k,
    float distLo,
    float distHi,
    float distMd,
    float distAcc,
    Interval distEstIA
  );

void insereCandidatoNaLista(candidato_t **prim,candidato_t *cand,QFILA_t qual, cmpCands_t *cmp);
// Insere cand na lista prim, supostamente em ordem {qual}, mantendo a ordem da mesma.
// Supoe que valor(c,q) devolve o valor a ser usado para ordenar o candidato.
// A funcao de comparacao deve ser apropriada para a fila {qual}.

int excluiCandidatoDaLista(candidato_t **prim,candidato_t *cand,QFILA_t qual);
// Exclui cand da lista prim, supostamente em ordem {qual}.
// Devolve 1 se achou, 0 se nao achou

#endif
