#include <operacoes_b.h>
#include <geraYuvGrad.h>
#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h>

void criaImagem(char *dir,char *name,char *tipo,int res_max,char *ext,char *dest,int opt);

void criaImagem_1(char *orig,char *dest);

void criaImagem_2(char *orig,char *dest);

void criaImagem_3(char *orig,char *dest);

void criaImagem_4(char *orig,char *dest);

void criaImagem_5(char *A_orig,char *B_orig,char *C_orig,char *A_dest,char *B_dest,char *C_dest);

void criaImagem_6(char *bandir,char *dest,char *nome_imagem[],int numImgs,int canais,int nh,int op,int mem);

int main(int argc, char** argv)
{
  // Coloque antes de alocar
  /*void *trash = malloc(1);                 
  struct mallinfo info;   
  int MemDinInicial, MemDinFinal;
  free(trash); 
  info = mallinfo();
  MemDinInicial = info.uordblks;
*/


  
  int op = atoi(argv[1]);
  if (op == 1)
  {  
    char *dir = argv[2];
    char *nome = argv[3];
    char *tipo = argv[4];
    int res_max= atoi(argv[5]);
    char *ext = argv[6];
    char *dest = argv[7];
    int opt=0;
    if (strcmp(tipo,"Lo")==0)
       opt = 0;
    else if (strcmp(tipo,"Hi")==0)
       opt = 1;
    else if (strcmp(tipo,"Md")==0)
       opt = 2;
    else if (strcmp(tipo,"Sd")==0)
       opt = 4;

    criaImagem(dir,nome,tipo,res_max,ext,dest,opt);
  }
  else if (op == 0)
  {
     char *orig = argv[2];
     char *dest = argv[3];
     fprintf(stderr, "Origem: %s -> Destino: %s, op:%d\n", orig,dest,op);
     criaImagem_1(orig,dest);
  }
  else if (op == 2)
  {
     char *orig = argv[2];
     char *dest = argv[3];
     fprintf(stderr, "Origem: %s -> Destino: %s, op:%d\n", orig,dest,op);
     criaImagem_2(orig,dest);
  }
  else if (op == 3)
  {
     char *orig = argv[2];
     char *dest = argv[3];
     fprintf(stderr, "Origem: %s -> Destino: %s, op:%d\n", orig,dest,op);
     criaImagem_3(orig,dest);
  }
  else if (op == 4)
  {
     char *orig = argv[2];
     char *dest = argv[3];
     fprintf(stderr, "Origem: %s -> Destino: %s, op:%d\n", orig,dest,op);
     criaImagem_4(orig,dest);
  }
  else if (op == 5)
  {
     char *A_orig=argv[2];
     char *B_orig=argv[3];
     char *C_orig=argv[4];
     char *A_dest=argv[5];
     char *B_dest=argv[6];
     char *C_dest=argv[7];
     fprintf(stderr, "Origem: %s %s %s-> Destino: %s %s %s, op:%d\n", A_orig,B_orig,C_orig,A_dest,B_dest,C_dest,op);
     criaImagem_5(A_orig,B_orig,C_orig,A_dest,B_dest,C_dest);
  }
  else if (op == 6)
  {
    char *bandir = argv[2];
    char *dest = argv[3];
    int numImgs = atoi(argv[4]);
    int canais = atoi(argv[5]);
    int nh = atoi(argv[6]);
    int op = atoi(argv[7]);
    int mem = atoi(argv[8]);
    // indice do primeiro argv[] que eh nome de imagem:
    int iarg_imagens = 9;

    assert(argc == iarg_imagens + numImgs);

    criaImagem_6(bandir,dest,&(argv[iarg_imagens]),numImgs,canais,nh,op,mem);
  }
  else
  {
     fprintf(stderr, "./criaImagem [(0):uma imagem normalizado, (1):todas escalas, (2):uma imagem normal, (3):separa canais], (4):em cada canal, (5):normaliza A B C simples\n");
     fprintf(stderr, "0 {ORIG} {DEST}\n");
     fprintf(stderr, "1 {DIR} {NOME} {TIPO} {SCALE} {EXT} {DEST}\n");
     fprintf(stderr, "2 {ORIG} {DEST}\n");
     fprintf(stderr, "3 {ORIG} {DIRDEST}\n");
     fprintf(stderr, "4 {ORIG} {DIRDEST}\n");
     fprintf(stderr, "5 {ORIGA} {ORIGB} {ORIGC} {DESTA} {DESTB} {DESTC}\n");
     fprintf(stderr, "6 {ORIG} {DIRDEST} {NUMIMGS} {CANAIS} {NH} {OP} {MEM}\n");
  }


/*
  info = mallinfo();
  MemDinFinal = info.uordblks;
  if (MemDinInicial!=MemDinFinal)
    printf("\n\nMain loop: Dinamic memory was not completely deallocated (%d, %d)\n", MemDinInicial,MemDinFinal);
*/


  return 0;
}

void criaImagem(char *dir,char *name,char *tipo,int res_max,char *ext,char *dest,int opt)
{
  char *filename=NULL;
  int i;
  for (i=0;i<=res_max;i++) 
  {
    asprintf(&filename,"%s/%s/%s/R%02d.%s",dir,name,tipo,i,ext);
    float_image_t *img=getImageOpenRGB(filename,opt);
    float_image_t *grad=criaImagem_Gradiente(img);
    asprintf(&filename,"%s/%s_R%02d_%s.%s",dest,name,i,tipo,ext);
    ex_write_image(NULL,filename,grad,opt);
    float_image_free(img);
    float_image_free(grad);
  }
  free(filename);
}

void criaImagem_1(char *orig,char *dest)
{
  float_image_t *img=getImageOpenRGB(orig,2);
  float_image_t *grad=criaImagem_Gradiente(img);
  ex_write_image(NULL,dest,grad,2);
  float_image_free(img);
  float_image_free(grad);
}

void criaImagem_2(char *orig,char *dest)
{
  float_image_t *img=getImageOpenRGB(orig,2);
  float_image_t *grad=criaImagem_Gradiente_Normal(img);
  ex_write_image(NULL,dest,grad,2);
  float_image_free(img);
  float_image_free(grad);
}

void criaImagem_3(char *orig,char *dest)
{
  float_image_t *img=getImageOpenRGB(orig,2);
  separa_canais(img,dest);
  float_image_free(img);
}

void criaImagem_4(char *orig,char *dest)
{
  float_image_t *img=getImageOpenRGB(orig,2);
  float_image_t *grad=criaImagem_Gradiente_por_Canal(img);
  ex_write_image(NULL,dest,grad,2);
  float_image_free(img);
  float_image_free(grad);
}

void criaImagem_5(char *A_orig,char *B_orig,char *C_orig,char *A_dest,char *B_dest,char *C_dest)
{
  float_image_t *Aimg=getImageOpenRGB(A_orig,2);
  float_image_t *Bimg=getImageOpenRGB(B_orig,2);
  float_image_t *Cimg=getImageOpenRGB(C_orig,2);

  calculaGradienteABC(&Aimg,&Bimg,&Cimg);

  ex_write_image(NULL,A_dest,Aimg,2);
  ex_write_image(NULL,B_dest,Bimg,2);
  ex_write_image(NULL,C_dest,Cimg,2);

  float_image_free(Aimg);
  float_image_free(Bimg);
  float_image_free(Cimg);
}

void criaImagem_6(char *bandir,char *dest,char *nome_imagem[],int numImgs,int canais,int nh,int op,int mem)
{
  rodaHistogramaBase(bandir,dest,nome_imagem,numImgs,canais,nh,op,mem);
}
