/* Last edited on 2009-12-14 00:36:21 by stolfilocal */

#include <estimaDistancia_b.h>
#include <estimaDistancia_EUGRADYUV.h>
#include <estimaDistancia_EURGB.h>
#include <geraYuvGrad.h>
#include <operacoes_b.h>
#include <assert.h>

float calcula_dist_EUGRADYUV
  ( 
    float_image_t *Amd,
    float_image_t *Bmd,
    int bgZero,
    int *ndistExP
  )
{
  demand(! bgZero, "bgZero com distancia de gradiente nao funciona");
  float_image_t *GAmd = criaImagem_Gradiente(Amd);
  float_image_t *GBmd = criaImagem_Gradiente(Bmd);
  float distRes = calcula_dist_EURGB(GAmd,GBmd,bgZero,ndistExP);
  float_image_free(GAmd);
  float_image_free(GBmd); 
  
  return distRes;
}

float calcula_dist_EUGRAD
  ( 
    float_image_t *Amd,
    float_image_t *Bmd,
    int bgZero,
    int *ndistExP
  )
{
  demand(! bgZero, "bgZero com distancia de gradiente nao funciona");
  float_image_t *GAmd = criaImagem_Gradiente_Normal(Amd);
  float_image_t *GBmd = criaImagem_Gradiente_Normal(Bmd);
  float distRes = calcula_dist_EURGB(GAmd,GBmd,bgZero,ndistExP);
  float_image_free(GAmd);
  float_image_free(GBmd); 
  
  return distRes;
}

void estima_dist_EUGRADYUV
  ( float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  )
{
  if (res==0)
  {
    float valor = calcula_dist_EUGRADYUV(AmdLo,BmdLo,bgZero,ndistExP);
    dist[0] = dist[1] = dist[2] = valor;
  }
  else
  {
    dist[0] = 0.0; dist[1] = 1.0; dist[2] = 0.5;
  }
}

void estima_dist_EUGRAD
  ( float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  )
{
  if (res==0)
  {
    float valor = calcula_dist_EUGRAD(AmdLo,BmdLo,bgZero,ndistExP);
    dist[0] = dist[1] = dist[2] = valor;
  }
  else
  {
    dist[0] = 0.0; dist[1] = 1.0; dist[2] = 0.5;
  }
}
