/* Last edited on 2009-12-14 00:04:43 by stolfilocal */
#ifndef estimaDistancia_EUGRADYUV_H
#define estimaDistancia_EUGRADYUV_H

#define _GNU_SOURCE
#include <stdio.h>
#include <bool.h>        
#include <float_image.h> 
#include <ia.h>


float calcula_dist_EUGRADYUV
  ( 
    float_image_t *Amd,
    float_image_t *Bmd,
    int bgZero,
    int *ndistExP
  );
/* Calcula a distancia euclidiana entre os gradientes normalizados
  das duas imagens {A} e {B}. Exige {bgZero = 0}.
  Incrementa {*ndistExP}.  Erros de arredondamento so considerados
  parte da distancia. */

float calcula_dist_EUGRAD
  ( 
    float_image_t *Amd,
    float_image_t *Bmd,
    int bgZero,
    int *ndistExP
  );
/* Calcula a distancia euclidiana entre os gradientes
  das duas imagens {A} e {B}. Exige {bgZero = 0}.
  Incrementa {*ndistExP}.  Erros de arredondamento so considerados
  parte da distancia. */
  
void estima_dist_EUGRADYUV
  ( float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  );  
/* Estima a distancia euclidiana do gradiente normalizado de duas imagens {A} e {B}
  a partir de suas versoes na escala {res}.
  Exige {bgzero=0}. Se {res = 0} supoe que {Amdlo,Bmdlo} sao os valores exatos
  das imagens, calcula a distancia exata, e devolve um
  intervalo singular. Senao devolve o intervalo [0_1]
  pois nao eh possivel estimar melhor.
  Incrementa {*ndistExP} e/ou {*ndistIAP} conforme o caso. */

void estima_dist_EUGRAD
  ( float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  );  
/* Estima a distancia euclidiana do gradiente de duas imagens {A} e {B}
  a partir de suas versoes na escala {res}.
  Exige {bgzero=0}. Se {res = 0} supoe que {Amdlo,Bmdlo} sao os valores exatos
  das imagens, calcula a distancia exata, e devolve um
  intervalo singular. Senao devolve o intervalo [0_1]
  pois nao eh possivel estimar melhor.
  Incrementa {*ndistExP} e/ou {*ndistIAP} conforme o caso. */
 
#endif  
