/* Last edited on 2009-12-14 00:04:33 by stolfilocal */
#ifndef estimaDistancia_EURGB_H
#define estimaDistancia_EURGB_H

#define _GNU_SOURCE
#include <stdio.h>
#include <bool.h>        
#include <float_image.h> 
#include <ia.h>

float calcula_dist_EURGB
  ( float_image_t *Amd,
    float_image_t *Bmd,
    int bgZero,
    int *ndistExP
  );
/* Calcula a distancia euclidiana entre duas imagens {A} e {B}.
  Se {bgZero = 1} trata o valor 0 como fundo.
  Incrementa {*ndistExP}.  Erros de arredondamento so considerados
  parte da distancia. */

void estima_dist_EURGB
  ( float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  );
/* Estima a distancia euclidiana entre duas imagens {A} e {B}
  a partir de suas versoes na escala {res}.
  Se {bgZero = 1} trata o valor 0 como fundo.
  Se {res = 0} supoe que {Amdlo,Bmdlo} sao os valores exatos
  das imagens, calcula a distancia exata, e devolve um
  intervalo singular. Senao usa aritmetica intervalar.
  incrementa {*ndistExP} e/ou {*ndistIAP} conforme o caso. */

#endif
