/* Last edited on 2009-12-14 17:22:40 by stolfilocal */
#ifndef estimaDistancia_b_H
#define estimaDistancia_b_H

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <bool.h>        
#include <float_image.h> 
#include <ia.h>

typedef enum {
  QDIST_EURGB = 0,     // Distância euclidiana no espaço RGB.
  QDIST_EUGRADYUV = 1,  // Distância euclidiana do gradiente normalizado no espaço YUV.
  QDIST_EUGRAD = 2,
} QDIST_t;

double calculaLambda(int cumul,int res,int res_max,double base);
//Calcula o peso {lambda} a ser atribuído à distância de imagens na escala {res}
//  no cálculo da distância total.
//  Se {cumul} é 0, a distância total é apenas a distância na escala 0.
//  Se {cumul} é 1, a distância total é a soma das distâncias em cada escala {res},
//    com peso proporcional a {base^res}.
//Os lambdas são normalizados de modo a somar 1 para {res} variando de 0 a {res_max} inclusive.

float calcula_dist_Monoescala( 
    float_image_t *A,
    float_image_t *B,
    int bgZero,
    QDIST_t qualDist,
    int *ndistExP
  );
/* Calcula a distancia entre duas imagens {A,B}. A distancia  definida por {qualDist}
  (0 = euclidiana simples, 1= euclidiana do gradiente).  Se {bgZero} eh 1, trata valor 0 como fundo.
  Incrementa {*ndistExP}. */
  
void estima_dist_Monoescala
  ( 
    float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max,
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    QDIST_t qualDist,
    float dist[],
    int *ndistExP,
    int *ndistIAP
  );
/*  Estima a distancia monoescala de duas imagens {A,B}, examinando as imagens 
  reduzidas na escala {res} qualquer entre 0 e {res_max}. Devolve o limite inferior {dist[0]}, limite
  superior {dist[1]}, e valor esperado (no sentido rms) {dist[2]}.  A distancia
  e definida por {qualDist} (0 = euclidiana simples, 1= euclidiana do gradiente). 
  Se {bgZero} eh 1, trata valor 0 como fundo.
  Exige as imagens com os valores minimos {aLo,bLo}, valores maximos {aHi,bHi}, valores médios {AMdLo,AMdHi,BMdLo,BMdHi}, e
  desvios {ASdLo,ASdHi,BSdLo,BSdHi} dos pixels de {A} e {B}. 
  
  Se {usa_IA} eh 1, utiliza aritmética intervalar
  Se {usa_MD_SD} eh 1, utiliza média e desvio-padrão
  Se {usa_IA} e {usa_MD_SD} são 1, então utiliza ambas e devolve interseccao. */

void acumula_dist_Multiescala
  (
    float_image_t *A,
    float_image_t *B,
    int bgZero,
    QDIST_t qualDist,
    float *distAcc,
    double lambda,
    int *ndistExP
  );
  /* Acumula em {*distAcc} mais um termo da distância cumulativa multi-escala do tipo
    {qualDist}, calculado sobre as imagens (geralmente reduzidas) {A,B},
    e ponderado com peso {lambda}. Os parametros {qualDist,bgZero} tem o mesmo
    significado acima.  Incrementa {*ndistExP}. */

void estima_dist_Multiescala
  (
    float_image_t *Alo, 
    float_image_t *Ahi,
    float_image_t *AmdLo,
    float_image_t *AmdHi,
    float_image_t *AsdLo,
    float_image_t *AsdHi,
    float_image_t *Blo,
    float_image_t *Bhi,
    float_image_t *BmdLo,
    float_image_t *BmdHi,
    float_image_t *BsdLo,
    float_image_t *BsdHi,
    int res,
    int res_max, 
    int bgZero,
    int usa_IA,
    int usa_MD_SD,
    QDIST_t qualDist,
    float *distAcc,
    double lambda[],
    float dist[],
    Interval *distEstIA,
    int *ndistExP,
    int *ndistIAP
  );
  /* Calcula estimativa intervalar para a distância cumulativa multi-escala do tipo
    {qualDist}, ponderada com pesos {lambda[0..res_max]}.
    Supõe que {distAcc} contém a soma das distâncias (exatas) ponderadas
    para as escalas {res+1..res_max},  e que as imagens dadas são as versões na escala {res}.
    Atualiza {*distAcc} somando-lhe {lambda[res]*dist} onde {dist}  a distancia exata
    na escala {res}. Os parametros {qualDist,bgZero,usa_IA,usa_MD_SD} tem o mesmo
    significado acima.  Incrementa {*ndistExP,*ndistIAP} conforme o caso.
    
    Na entrada, {*distEstIA} deve conter uma estimativa intervalar para a distancia
    monoescala na escala {res} entre {AmdLo} e {BmdLo}.  O procedimento pode conferir esta estimativa.
    Na sada, esta estimativa ser atualizada com uma estimativa para a distancia 
    monoescala para as imagens na escala {0..res-1}. */

#endif
