#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
    
#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 
#include <malloc.h>

void gravaImagem(float_image_t *img,char *name);
float_image_t *leImagem(char *name);
void extraiCanais(char *name);

void gravaImagem(float_image_t *img,char *name)
{
    FILE *wr = open_write(name,TRUE);
    int chns = img->sz[0];
    pnm_image_t *pim = float_image_to_pnm_image(img, chns, NULL, NULL, NULL, 255, FALSE);
    pnm_image_fwrite(wr, pim, FALSE);
    pnm_image_free(pim);
}

float_image_t *leImagem(char *name)
{
  char *n=NULL;
  asprintf(&n,"%s.ppm",name);
  FILE *rd = open_read(n, TRUE);
  pnm_image_t *pim = pnm_image_fread(rd);
  float_image_t *fim = float_image_from_pnm_image(pim, NULL, NULL, FALSE);
  pnm_image_free(pim);
  return fim;
}

void extraiCanais(char *name)
{
  float_image_t *img=leImagem(name);
  float_image_t *R = float_image_new(img->sz[0],img->sz[1],img->sz[2]);
  float_image_t *G = float_image_new(img->sz[0],img->sz[1],img->sz[2]);
  float_image_t *B = float_image_new(img->sz[0],img->sz[1],img->sz[2]);
  int i=0,j=0,c=0;
  float rgb[3];
  for (i=0;i<img->sz[1];i++)
    for (j=0;j<img->sz[2];j++)
      {
	for (c=0;c<img->sz[0];c++)
	{
	  rgb[0]=0;
	  rgb[1]=0;
	  rgb[2]=0;
	  if (c==0)	  
	  {
	  	rgb[c]=float_image_get_sample(img,c,i,j);
		float_image_set_pixel(R,i,j,rgb);
	  }		  
	  else if (c==1)
	  {
	  	rgb[c]=float_image_get_sample(img,c,i,j);
		float_image_set_pixel(G,i,j,rgb);
	  }
	  else
	  {
	  	rgb[c]=float_image_get_sample(img,c,i,j);
		float_image_set_pixel(B,i,j,rgb);
	  }
	}		 
      }
  char *n=NULL;
  asprintf(&n,"%s_r.ppm",name);
  gravaImagem(R,n);
  asprintf(&n,"%s_g.ppm",name);
  gravaImagem(G,n);
  asprintf(&n,"%s_b.ppm",name);
  gravaImagem(B,n);
}

int main(int argc, char** argv)
{
  char *name = argv[1];
  extraiCanais(name);
  return 1;
}

