/* Last edited on 2009-12-14 03:41:41 by stolfilocal */
#include <principalRGB.h>

//PROTOTIPOS

void calculaCustos(int distsExPorNivel[],int distsIAPorNivel[],double custoPorNivel[],int res_max,double delta);
void gravaCustos(char *bandir,double ct);
void gravaDistsECustos(char *bandir,char *model_name,char *ext,int distsExPorNivel[],int distsIAPorNivel[],double custoPorNivel[],int res_max,int criteriosEscolha,int musis,int usa_IA,int usa_MD_SD,int cumul,float base,int num_resultados);

//IMPLEMENTACOES

void calculaCustos(int distsExPorNivel[],int distsIAPorNivel[],double custoPorNivel[],int res_max,double delta)
{
  //fprintf(stderr, "\nCusto Total\n");
  int i;
  for (i=res_max;i>=0;i--)
  {
    int ndEx=distsExPorNivel[i];
    int ndIA=distsIAPorNivel[i];
    double elev=pow(0.25,i);
    double custo=(ndEx*elev) + (ndIA*elev*delta);
    custoPorNivel[i]=custo;
  }
}

void gravaDistsECustos(char *bandir,char *model_name,char *ext,int distsExPorNivel[],int distsIAPorNivel[],double custoPorNivel[],int res_max,int criteriosEscolha,int musis,int usa_IA,int usa_MD_SD,int cumul,float base,int num_resultados)
{
   char *nomeArq=NULL;
   asprintf(&nomeArq,"%s/%s-dists-custos-ext%s-cr%d-m%d-ia%d-md%d-c%d-b%3.1f-nr%d.txt",bandir,model_name,ext,criteriosEscolha,musis,usa_IA,usa_MD_SD,cumul,base,num_resultados);
   //printf("Nome: %s\n",nomeArq);
   FILE *arq = fopen(nomeArq, "a");
   free(nomeArq);
   char *linha = NULL;
   int i;
   int distsEx_total = 0;
   int distsIA_total = 0;
   double custo_total=0;
   for (i=res_max;i>=0;i--)
   {
     asprintf(&linha,"%3d %7d %7d %11.5f", i, distsExPorNivel[i],distsIAPorNivel[i],custoPorNivel[i]);
     fprintf(arq,"%s\n",linha);
     //fprintf(stderr, "%s\n",linha);
     free(linha); linha = NULL;
     custo_total += custoPorNivel[i];
     distsEx_total += distsExPorNivel[i];
     distsIA_total += distsIAPorNivel[i];
   }
  
   asprintf(&linha,"%3d %7d %7d %11.5f", -1, distsEx_total,distsIA_total,custo_total);
   fprintf(arq,"%s\n",linha);
   //fprintf(stderr, "%s\n",linha);
   fprintf(arq,"\n");
   //fprintf(stderr, "\n");
   free(linha); linha = NULL;
   fclose(arq);
}

int main(int argc, char** argv)
{
   int debug=0;
   char *bandir = argv[1];     // Diretorio com banco de imagens reduzidas
   int num_imagens = atoi(argv[2]);
   int res_max = atoi(argv[3]);
   int fator = atoi(argv[4]);
   char *model_name = argv[5];
   char *ext = argv[6];
   int bgZero = atoi(argv[7]);
   int musis = atoi(argv[8]);
   int criteriosEscolha = atoi(argv[9]);
   int usa_IA = atoi(argv[10]);
   int usa_MD_SD = atoi(argv[11]);
   QDIST_t qualDist = atoi(argv[12]);
   int cumul = atoi(argv[13]);
   double base = atof(argv[14]);
   int num_resultados = atoi(argv[15]);
   int opcaoPlot = atoi(argv[16]);
   // indice do primeiro argv[] que eh nome de imagem:
   int iarg_imagens = 17;

   assert(argc == iarg_imagens + num_imagens);

if (debug)
{

   fprintf(stderr, "\n+++++++++++++++++++++++++++++++INICIO++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");

   fprintf(stderr, "parametros:\n");
   fprintf(stderr, "diretório do banco = %s\n", bandir);
   fprintf(stderr, "número de imagens do banco = %d\n", num_imagens);
   fprintf(stderr, "escala de reducão máxima da imagem (0 = original) = %d\n", res_max);
   fprintf(stderr, "fator de redução das imagens = %d\n", fator);
   fprintf(stderr, "nome (número) da imagem modelo a procurar = %s\n", model_name);
   fprintf(stderr, "extensão das imagens = %s\n", ext);
   fprintf(stderr, "valor zero significa fundo = %d\n", bgZero);
   fprintf(stderr, "valor (0) bruta, (1) MuSIS = %d\n", musis);
   fprintf(stderr, "valor (0): menor distLo - (1): maior distHi - (2): menor distMd - (3): valor esperado de dLo - (4): nível decrescente - (5): fração decrescente = %d\n", criteriosEscolha);
   fprintf(stderr, "valor (1) significa usar Aritmética Intervalar = %d\n", usa_IA);
   fprintf(stderr, "valor (1) significa usar Média e Desvio-Padrão = %d\n", usa_MD_SD);
   fprintf(stderr, "valor (0) dist2, (1) dist2Grad = %d\n", qualDist);
   fprintf(stderr, "valor (0) não, (1) sim = %d\n", cumul);
   fprintf(stderr, "valor da base dos pesos de escalas = %f\n", base);
   fprintf(stderr, "número de resultados desejados = %d\n", num_resultados);
   fprintf(stderr, "opção de plotagem (0) nao (1) tela (2) arquivo = %d\n", opcaoPlot);
}
   int distsExPorNivel[res_max+1];
   int distsIAPorNivel[res_max+1];

   int res;
   for (res = 0; res <= res_max; res++) { distsExPorNivel[res] = distsIAPorNivel[res] = 0; }   

   if (musis)
     { buscaMuSIS
         ( bandir, model_name, ext, res_max, fator,
           num_imagens, &(argv[iarg_imagens]),
           num_resultados, distsExPorNivel, distsIAPorNivel, 
           bgZero, criteriosEscolha, usa_IA, usa_MD_SD, qualDist, cumul, base,
           opcaoPlot
         );
     }
   else
     { buscaBruta(bandir,model_name,ext,res_max,fator,num_imagens,&(argv[iarg_imagens]),num_resultados,distsExPorNivel,bgZero,qualDist,cumul,base);
     }
       

if (debug)
{   
   fprintf(stderr, "\n++++++++++++++++++++++++++++++++++FIM++++++++++++++++++++++++++++++++++++++\n");
   fprintf(stderr, "+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
}

   double delta = 2.0;
   double custoPorNivel[res_max+1];
   calculaCustos(distsExPorNivel,distsIAPorNivel,custoPorNivel,res_max,delta);
   
   gravaDistsECustos(bandir,model_name,ext,distsExPorNivel,distsIAPorNivel,custoPorNivel,res_max,criteriosEscolha,musis,usa_IA,usa_MD_SD,cumul,base,num_resultados);
  return 0;
}
