#ifndef reducaoRGB
#define reducaoRGB

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 

// Verifica se pixel é todo zero:
bool_t pixelTodoZero(float val[], int nch);

// Reduz uma imagem RGB (3 canais) para tons de cinza (1 canal)
float_image_t *getImageLuminosidade(float_image_t *I);

//cálcula a redução da imagem baseada em média e variância
void calculaMediaVarianciaRGB(float_image_t *Md,float_image_t *Vr,int fator);

//Calcula a versao reduzida da imagem usando mínimo de cada região, diminuído por {intervalo}. 
// Se {ignorazero} é verdade, ignora pixels que são zero.
void calculaIntervaloLoRGB(float_image_t *I,int k,float intervalo,bool_t ignorazero);

//Calcula a versao reduzida da imagem usando máximo de cada região, aumentado por {intervalo}. 
// Se {ignorazero} é verdade, ignora pixels que são zero.
void calculaIntervaloHiRGB(float_image_t *I,int k,float intervalo,bool_t ignorazero);

//Calcula media e variancia de uma regiao da imagem, dadas a media e variancia dos pixels.
void getMediaVarianciaRegiaoRGB(float_image_t *Md,float_image_t *Vr,float md[3],float vr[3],int inil,int fiml,int inic,int fimc);

// Calcula o mínimo de todos os pixels na região, diminuídos por {intervalo}. 
// Se {ignorazero} é verdade, ignora pixels que são zero; nesse caso, se
// todos os pixels são zero, devolve {0,0,0}. 
void getInterMenorRegiaoRGB(float_image_t *I,int inil,int fiml,int inic,int fimc,float menor[3],float intervalo,bool_t ignorazero);

// Calcula o máximo de todos os pixels na região, aumentados por {intervalo}. 
// Se {ignorazero} é verdade, ignora pixels que são zero; nesse caso, se
// todos os pixels são zero, devolve {0,0,0}. 
void getInterMaiorRegiaoRGB(float_image_t *I,int inil,int fiml,int inic,int fimc,float maior[3],float intervalo,bool_t ignorazero);

float_image_t *calculaDesvioPadrao(float_image_t *Vr);
//Calcula o desvio padrão a partir de uma imagem {Vr} contendo os valores de variancia
//O retorno é uma nova imagem {Sd} contendo os valores correspondentes ao desvio padrão

#endif
