# Generic Makefile to run tests of one or more programs
# Last edited on 2008-08-09 09:51:28 by stolfi

######################################################################
# To be included by the top-level Makefile in the program's directory.
# The caller must define
#
#   ${PROG} or ${PROGS}  test programs (whose sources are in current directory)
#   ${PROGDIR}           the directory containing the executable program and its sources
#   
# The client must define the "all", "run", and "clean" targets.

ifeq "/${PROGS}" "/"
PROGS := ${PROG}
endif

ifneq "/${PROGS}" "/"
ifneq "/${PROGDIR}" "/"

SHELL := /bin/sh

#---------------------------------------------------------------------
# Phony "make" targets:
# Client hould define "all" and "clean"

.PHONY:: \
  default-action \
  all actions \
  build build-progs \
  install uninstall \
  clean

#---------------------------------------------------------------------
# Default target: call the client's "all" target.
default-action: all

# ----------------------------------------------------------------------
# Locations of imported packages

# Location of Stolfi's headers and libraries:
JS_PUB_DIR := ${STOLFIHOME}
JS_LIB_DIR := ${JS_PUB_DIR}/lib/${PLATFORM}
JS_INC_DIR := ${JS_PUB_DIR}/include

#---------------------------------------------------------------------
# "make actions" performs the actions listed in ${ACTIONS}, if any
actions:
ifeq "/${ACTIONS}" "/"
	@echo '$${ACTIONS} is empty'
else
	${MAKE} ${ACTIONS}
endif

#---------------------------------------------------------------------
# "make build" and "make build-progs" make sure that the
# executables in ${PROGDIR} are up to date:

build: build-progs
  
PROG_XFILES := ${addprefix ${PROGDIR}/, ${PROGS}}

build-progs: ${PROG_XFILES}

${PROG_XFILES}: \
          ${wildcard ${PROGDIR}/*.h ${PROGDIR}/*.c} \
          ${wildcard ${JS_INC_DIR}/*.ho} \
          ${wildcard ${JS_LIB_DIR}/*.a ${JS_LIB_DIR}/*.so}
	@echo "rebuilding ${PROG_XFILES} ..."
	cd ${PROGDIR}/. && ${MAKE} ${PROGS}

#---------------------------------------------------------------------
# "make install" is a no-op:

install: 

#---------------------------------------------------------------------
# "make uninstall" is a no-op:

uninstall: 

#---------------------------------------------------------------------
# "make clean" deletes all derived files.
# It is a double-colon rule so that clients may add more actions.

clean::
        
endif
endif
# End of ${PROG} ${PROGDIR} section.
######################################################################

