# Makefile for a directory with several sub-directories 
# Last edited on 2008-08-09 10:04:18 by stolfi

# Client may define ${SUBDIRS}, a list of sub-directories
# of the current directory.  "make XXX" will perform "make XXX"
# on each subdirectory where "make" needs to  run.  Alternatively list of 
# subdirectories with specific contents:
#
#   ${LIB_DIRS}       libraries
#   ${PROG_DIRS}      excutable prog packages
#   ${PROG_TEST_DIRS} test runs of program packages
#   ${LIB_TEST_DIRS}  test programs of libraries, and runs thereof
#  
# some actions may be propagated only to some kinds of sub-directories

ifeq "/${SUBDIRS}" "/"
SUBDIRS := ${LIB_DIRS} ${PROG_DIRS} ${LIB_TEST_DIRS} ${PROG_TEST_DIRS}
endif

.PHONY:: \
  default-action \
  all actions \
  depend clean uninstall install check \
  setup \
  tar-export \
  find-all-sources  

# ----------------------------------------------------------------------
# "make" with no action does "make all" which must be defined by user:
default-action: all

# ----------------------------------------------------------------------
# "make find-all-sources" creates lists of source files, makefiles, 
# C files, etc.  the current directory:

find-all-sources: 
	  make-sources-cprogs-makefiles-lists -notheses        

# ----------------------------------------------------------------------
# "make all"
# "make clean"
# "make uninstall"
# "make install"
# "make build"
# "make check"
# "make depend"
# "make tar-export"
# These actions are just performed on all sub-directories in the 
# client-defined list ${SUBDIRS}, in order.

all:
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make all ; \
          ) ; \
        done

build:
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make build ; \
          ) ; \
        done

uninstall:
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make uninstall ; \
          ) ; \
        done

install:
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make install ; \
          ) ; \
        done

check: 
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make check ; \
          ) ; \
        done

clean: 
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make clean ; \
          ) ; \
        done

tar-export: 
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make tar-export ; \
          ) ; \
        done

depend: 
	@for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make depend ; \
          ) ; \
        done

# ----------------------------------------------------------------------
# "make actions" makes the list ${ACTIONS} defined by the user in each
# directory in turn:

actions: 
	for dir in ${SUBDIRS}; do \
          ( echo '= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ='; \
            echo "$$dir"; \
            cd $$dir/. && \
            make ${ACTIONS} ; \
          ) ; \
        done

# ----------------------------------------------------------------------
# "make setup" creates the user's global repositories for "make install"

########################################################################
# Client must define ${PLATFORM}

ifneq "/${PLATFORM}" "/"

# User's global repositories:
INST_LIB_DIR := ${HOME}Projeto/Programas/lib/${PLATFORM}
INST_INC_DIR := ${HOME}Projeto/Programas/include
#INST_BIN_DIR := ${HOME}Projeto/Programas/bin/${PLATFORM}
INST_LSP_DIR := ${HOME}Projeto/Programas/lisp/lib

setup: \
  ${INST_INC_DIR} \
  ${INST_LIB_DIR} \
  ${INST_LSP_DIR} \
  ${INST_BIN_DIR}

${INST_INC_DIR}: 
	mkdir -pv ${INST_INC_DIR}

${INST_LIB_DIR}: 
	mkdir -pv ${INST_LIB_DIR}

${INST_BIN_DIR}: 
	mkdir -pv ${INST_BIN_DIR}

${INST_LSP_DIR}: 
	mkdir -pv ${INST_LSP_DIR}

endif 
# end of ${PLATFORM} section
######################################################################

