# Generic Makefile for one or more self-contained scripts (awk, bask, etc.)
# Last edited on 2008-06-29 03:48:56 by stolfi

######################################################################
# To be included by the top-level Makefile in the program's directory.
# The caller must define 
#   ${PROG} or ${PROGS} (user-executable scripts)
#   ${LIB} or ${LIBS} (auxiliary script files used by the above).

ifeq "/${PROGS}" "/"
PROGS := ${PROG}
endif

ifeq "/${LIBS}" "/"
LIBS := ${LIB}
endif

ifneq "/${PROGS}${LIBS}" "/"

SHELL := /bin/sh

# Where to install the scripts
INST_PUB_DIR := ${STOLFIHOME}
INST_BIN_DIR := ${INST_PUB_DIR}/bin
INST_LIB_DIR := ${INST_PUB_DIR}/lib

# Make targets:
.PHONY:: \
  all actions \
  depend \
  uninstall uninstall-progs uninstall-libs \
  build build-progs build-libs check \
  install install-progs install-libs \
  clean

# all: uninstall clean build check install
all: uninstall build install

#---------------------------------------------------------------------
# "make actions" performs the actions listed in ${ACTIONS}, if any
actions:
ifeq "/${ACTIONS}" "/"
	@echo '$${ACTIONS} is empty'
else
	${MAKE} ${ACTIONS}
endif

#---------------------------------------------------------------------
# "make depend" does nothing

depend: 

#---------------------------------------------------------------------
# "make build" does nothing:

build: ${PROGS} ${LIBS}
  
#---------------------------------------------------------------------
# "make install" copies scripts and libs to the public dir.

install: install-progs install-libs

install-progs: ${PROGS}
	cp -p ${PROGS} ${INST_BIN_DIR}/

install-libs: ${LIBS}
	cp -p ${LIBS} ${INST_LIB_DIR}/

#---------------------------------------------------------------------
# "make uninstall" deletes the exported scripts and libs:

uninstall: uninstall-progs uninstall-libs

uninstall-progs:
	( cd ${INST_BIN_DIR}/. && rm -f ${PROGS} )

uninstall-libs:
	( cd ${INST_LIB_DIR}/. && rm -f ${LIBS} )

#---------------------------------------------------------------------
# "make archive" creates a tarball of scripts, libs, and Makefile.

NOW = ${shell date '+%Y-%m-%d-%H%M%S'}
TARBALL_NAME := ${NOW}.tgz
  
archive: ;\
  tar -cvzf ${TARBALL_NAME} \
          00-README Makefile \
            ${PROGS} \
            ${LIBS}

#---------------------------------------------------------------------
# "make check" runs the tests in the "tests" subdirectory.

TEST_DIR := tests

check: ${PROG}
	( cd ${TEST_DIR} && ${MAKE} all )

#---------------------------------------------------------------------
# "make clean" deletes all derived files.

clean:
	-/bin/rm -f core 
	( cd ${TEST_DIR} && ${MAKE} clean )

endif
# End of ${PROGS}/${LIBS} section.
######################################################################

