/* Last edited on 2006-11-22 00:26:52 by stolfi */
  /* ift_ppm.c - implementation of ift_ppm.h. */
/* Last edited on 2001-09-08 23:32:58 by stolfi */

#include "ift_ppm.h"
#include "ppm.h"

void ift_set_nodes_from_ppm_image(ppm_image *img, ImageGraph *G)
  {
    int h, v, k; 
    PixelNode *pg = &(G->node[0]);
    PixelValue yy;
    double fmaxval = (double)(img->maxval);
    if (img->cols != G->cols) { IFT_ERROR("cols mismatch"); }
    if (img->rows != G->rows) { IFT_ERROR("rows mismatch"); }
    /* Initialize unused channels: */
    for (k = 3; k < MAX_CHANNELS; k++) { yy.c[k] = 0; }
    /* Set pixels: */
    for (v = 0; v < G->rows; v++)
      for (h = 0; h < G->cols; h++)
        { pixel (*pm) = &(img->pix[v][h]);
          yy.c[0] = ((double)(PPM_GETR(*pm)))/fmaxval;
          yy.c[1] = ((double)(PPM_GETG(*pm)))/fmaxval;
          yy.c[2] = ((double)(PPM_GETB(*pm)))/fmaxval;
          pg->y = yy;
          pg++;
        }
  }

FILE *ift_open_write(char *name);
FILE *ift_open_read(char *name);

FILE *ift_open_write(char *name)
  { FILE *f; 
    if (name == NULL) pm_error("no file name given");
    else if (strlen(name) == 0) pm_error("empty file name");
    else if (strcmp(name, "-") == 0)
      { f = stdout; }
    else
      { f = pm_openw(name); }
    return f;
  }

FILE *ift_open_read(char *name)
  { FILE *f = NULL;
    if (name == NULL) pm_error("no file name given");
    else if (strlen(name) == 0) pm_error("empty file name");
    else if (strcmp(name, "-") == 0)
      { f = stdin; }
    else
      { f = pm_openr(name); }
    return f;
  }



#define ARG_ERROR(Msg,Arg) \
  { fprintf(stderr, "%s %s\n", Msg, Arg); pm_usage(usage); }
  
#define SET_NEXT(Var) \
  { if (((Var) != NULL) || (argn+1 >= argc)) \
      { ARG_ERROR("missing arg value", argv[argn]); } \
    (Var) = argv[argn+1]; ++argn; \
  }

extern double strtod(const char *, char **);

double parse_num_arg(char *str)
  { 
    double x; char *rest;
    x = strtod(str, &rest);
    if (*rest != '\0') { pm_error(txtcat("bad number: ", str)); }
    return x;
  }
