#ifndef float_image_hdyn_H
#define float_image_hdyn_H

/* Tools for high-dynamic-range mixing of PGM/PBM images. */
/* Last edited on 2008-11-23 18:44:06 by stolfi */ 

#include <r2.h>
#include <r2x2.h>
#include <r3x3.h>
#include <bool.h>
#include <jspnm_image.h>
#include <float_image.h>

typedef struct float_image_hdyn_params_t
  { /* Command line parameters: */
    double brght;     /* Brightness. */
    double ctrst;     /* Contrats. */
    double sigma;     /* Noise level. */
    double gamma;     /* Power law exponent. */
    int black;        /* Black offset. */
    int white;        /* White limit. */
  } float_image_hdyn_params_t;
  /* An {img_t} record contains user-given and computed data about an input image. */
  
float_image_t *float_image_hdyn_combine
  ( int n,                 /* Number of input images. */
    pnm_image_t *pim[],   /* Input images. */
    float_image_hdyn_params_t params[],
    bool_t verbose    
  );
  /* Combines the images {pim[0..n-1]} into a single float image.
    Corresponding pixels are converted to intervals using
    {sample_conv_hdyn_floatize}, then combined into a single interval
    with {sample_conv_hdyn_merge_intervals}, then converted to a float
    value. 
    
    Depending on the data, the resulting samples may be
    {NAN], {-INF}, or {+INF}. */

#endif
