#ifndef float_pnm_image_H
#define float_pnm_image_H

/* Conversion between PPM images and multichannel float images. */
/* Last edited on 2008-11-23 18:39:57 by stolfi */ 

#include <stdio.h>

#include <bool.h>
#include <jspnm.h>
#include <jspnm_image.h>
#include <float_image.h>

float_image_t *float_image_from_pnm_image
  ( pnm_image_t *img, 
    double lo[], 
    double hi[], 
    bool_t verbose
  );
  /* Converts a PGM or PPM image into a {float_image_t}.
    Each sample {iv} in channel {k} is converted to a float 
    with {sample_conv_floatize(iv, img->maxval, lo[k], hi[k],...)}.

    If {lo} is NULL, it defaults to a vector of zeros.
    If {hi} is NULL, it defaults to a vector of ones.

    Note that the row indices are reversed, so that row
    0 of {img} will be row {img->rows-1} of the result,
    and vice-versa.

    If {verbose} is TRUE, the procedure prints statistics of the
    conversion to {stderr}. */

pnm_image_t *float_image_to_pnm_image
  ( float_image_t *fim,
    int chns,
    double lo[],  /* Parameter order changed on 2008-11-10. */
    double hi[],  /* Parameter order changed on 2008-11-10. */
    int ch[],     /* Parameter order AND MEANING changed on 2008-11-10. */
    pnm_sample_t maxval, 
    bool_t verbose
  );
  /* Converts a {float_image_t} {fim} to a PGM/PPM image {pim}. The
    number of channels of {pim} with be {chns}, and the samples of
    channel {k} of {pim} will be taken from channel {ch[k]} of {fim}.
    If a channel index {ch[k]} is invalid, its samples are assumed to
    be all zeros.  If {ch} is NULL, it defaults to the identity vector
    {(0,1,2,...chns-1)}.
    
    Each sample {fv} of channel {c = ch[k]} of {fim} is converted to
    an integer sample in {0..maxval} by {float_image_quantize(fv,
    maxval, lo[k], hi[k], ...)}. If {lo} is NULL, it defaults to a
    vector of zeros. If {hi} is NULL, it defaults to a vector of ones.
    
    Note that the row indices are reversed, so that row
    0 of {img} will be row {img->rows-1} of the result,
    and vice-versa.

    If {verbose} is TRUE, the procedure prints statistics of the
    conversion to {stderr}.
    
    NOTE: the indexing of {lo} and {hi} changed from {c} 
    to {k} on 2008-11-10.  The order of the parameters
    {lo,hi,ch} was changed to make old uses stand out. */

#endif
