#ifndef i2_H
#define i2_H

/* Operations on points and vectors of Z^2 */
/* Last edited on 2007-01-03 22:02:38 by stolfi */

#include <vec.h>
#include <stdio.h>

typedef struct { int c[2]; } i2_t;

void i2_zero (i2_t *r);
  /* Sets {r} to the zero vector. */
  
void i2_all (int x, i2_t *r);
  /* Sets all coordinates of {r} to the value {x}. */
  
void i2_axis (int i, i2_t *r);
  /* Sets {r} to the {i}th vector of the canonical basis. */

void i2_add (i2_t *a, i2_t *b, i2_t *r);
  /* Sets {r = a + b}. */

void i2_sub (i2_t *a, i2_t *b, i2_t *r);
  /* Sets {r = a - b}. */

void i2_neg (i2_t *a, i2_t *r);
  /* Sets {r} to {-a}. */

int i2_L_inf_norm (i2_t *a);
  /* Returns the L-infinity norm of {a} (max absolute coordinate). */

int i2_L_inf_dist (i2_t *a, i2_t *b);
  /* Returns the L-infinity distance between {a} and {b} 
    (max absolute diff). */

void i2_print (FILE *f, i2_t *a);
  /* Prints {a} on file {f}, with some default format. */

void i2_gen_print (FILE *f, i2_t *a, char *fmt, char *lp, char *sep, char *rp);
  /* Prints {a} on file {f}, formatting each coordinate with {fmt}. 
    The strings {lp}, {sep}, and {rp} are printed respectively before,
    between, and after all the coordinates of {a}.  When NULL, they default 
    to "%16.8e", "(", " ", and ")", respectively. */

vec_typedef(i2_vec_t,i2_vec,i2_t);
  /* An {i2_vec_t} is a vector of {i2_t}s. */

#endif
