#ifndef jsfile_H
#define jsfile_H

/* File open with auto bomb-out; read line as new string. */
/* Last edited on 2006-11-01 20:11:06 by stolfi */

#include <stdio.h>

FILE *open_read(const char *name, int verbose);
FILE *open_write(const char *name, int verbose);
  /* Opens file for input or output, respectively. If {name} is "-",
    returns {stdin} or {stdout}, respectively. If {verbose} is TRUE,
    prints a message to {stderr}. Bombs out in case of failure
    (including {name} is NULL or an empty string). */
     
char *read_line(FILE *f);
  /* Reads the next line from file {f}, until '\n', NUL, or EOF.
    Returns it as a NUL-terminated string, without the final '\n'.
    Replaces TABs by single spaces. Allocates space for the result with 
    {malloc()}. Returns NULL iff the file is already at EOF. */
 
#endif
