#ifndef lsq_H
#define lsq_H

/* Miscellaneous tools for test programs. */
/* Last edited on 2007-12-05 20:04:32 by stolfi */

#define lsq_H_COPYRIGHT \
  "Copyright  2006  by the State University of Campinas (UNICAMP)"

#include <bool.h>

typedef void lsq_gen_case_t(int i, int nv, double v[], int nf, double f[]);
  /* The type of a function that generates a data record for least squares fitting.
    
    The parameter {i} is the sequential index of the data record. The
    data record will have {nv} independent variables, which the
    procedure stores into {v[0..nv-1]}, and {nf} dependent variables
    which the procedure stores into {f[0..nf-1]}. */

int lsq_fit
  ( int nv,     /* Number of independent variables. */
    int nf,     /* Number of dependent variables (functions to fit). */
    int nt,     /* Number of cases to generate. */
    lsq_gen_case_t *gen_case,
    double U[], /* Fitted linear transformation matrix. */
    bool_t verbose
  );
  /* Finds the matrix {U} that best approximates some function
    from {R^nv} to {R^nf}, over a given set of sample cases, by least squares.
    
    The procedure calls {gen_case(i,nv,v,nf,f)}, with {i} varying from 
    0 to {nt-1}, to generate the data records {v[0..nv-1]} and {f[0..nf-1]}
    for sample case {i}. 
    
    The matrix {U} should have {nv*nf} elements, interpreted as {nv}
    rows and {nf} columns. The approximation is defined as the
    vector-matrix product {f = v U}. Namely, column {j} of {U} is the
    coefficient vector of the linear combination of {v[0..nv-1]} that
    best approximates the function {f[j]}, in the sense of minimizing
    the sum of squared errors {|v U[*,j] - f[j]|^2} over all sample
    cases {v,f}.
    
    Returns the rank {r} of the least-squares system. If {r} is less
    than {nv}, it means that the {v} vectors generated by {gen_sel}
    belonged to a proper linear subspace of {R^{nv}}. In that case the
    best-fit map is not unique. */

#endif
