/* See argparser_geo.h. */
/* Last edited on 2008-07-14 22:27:48 by stolfi */

/* Copyright  2003 Jorge Stolfi, Unicamp. See note at end of file. */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <float.h>

#include <r2.h>
#include <r3.h>
#include <r4.h>
#include <argparser.h>

#include <argparser_geo.h>

void argparser_get_next_rn(argparser_t *pp, double p[], int n, double min, double max)
  { int i;
    for (i = 0; i < n; i++)
      { p[i] = argparser_get_next_double(pp, min, max); }
  }

r2_t argparser_get_next_r2(argparser_t *pp, double min, double max)
  { r2_t p;
    argparser_get_next_rn(pp, p.c, 2, min, max);
    return p;
  } 

r3_t argparser_get_next_r3(argparser_t *pp, double min, double max)
  { r3_t p;
    argparser_get_next_rn(pp, p.c, 3, min, max);
    return p;
  } 

r4_t argparser_get_next_r4(argparser_t *pp, double min, double max)
  { r4_t p;
    argparser_get_next_rn(pp, p.c, 4, min, max);
    return p;
  } 
  
r6_t argparser_get_next_r6(argparser_t *pp, double min, double max)
  { r6_t p;
    argparser_get_next_rn(pp, p.c, 6, min, max);
    return p;
  } 
  
r3_t argparser_get_next_r3_dir(argparser_t *pp)
  { r3_t d;
    argparser_get_next_rn(pp, d.c, 3, -DBL_MAX, +DBL_MAX);
    r3_dir(&d, &d);
    return d;
  } 

/* Copyright  2003 by Jorge Stolfi.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appears in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty of any kind.
*/
 
