/* argparser_geo.h -- extends argparser.h for geometric args. */
/* Last edited on 2008-07-14 22:27:36 by stolfi */

#ifndef argparser_geo_H
#define argparser_geo_H

/* Copyright  2003 Jorge Stolfi, Unicamp. See note at end of file. */

/* This interface provides convenient tools for parsing command
  line arguments whose values are real vectors. */

#include <r2.h>
#include <r3.h>
#include <r4.h>
#include <r6.h>
#include <argparser.h>

r2_t argparser_get_next_r2(argparser_t *pp, double min, double max);
r3_t argparser_get_next_r3(argparser_t *pp, double min, double max);
r4_t argparser_get_next_r4(argparser_t *pp, double min, double max);
r6_t argparser_get_next_r6(argparser_t *pp, double min, double max);
  /* Parses with {argparser_get_next_double} next {N} arguments, which
    must be in the range {[min.. max]}, as the coordinates of a point;
    where {N} is 2,3,4, or 6. */

void argparser_get_next_rn(argparser_t *pp, double p[], int n, double min, double max);
  /* Parses with {argparser_get_next_double} the next {n} arguments, 
    which must be in the range {[min .. max]}, and stores them in 
    {p[0.n-1]}. */

r3_t argparser_get_next_r3_dir(argparser_t *pp);
  /* Same as {argparser_get_next_r3} but normalizes result to unit length. */

/* Copyright  2003 by Jorge Stolfi.
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appears in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty of any kind.
*/

#endif
