/* See {float_pnm_image_io.h}. */
/* Last edited on 2008-07-30 18:35:04 by stolfi */

#include "float_pnm_image_io.h"

#include "jspnm_image.h"
#include "float_pnm_image.h"
#include <assert.h>
#include <bool.h>

float_image_t *float_pnm_image_read(char *filename, double gamma, double bias)
{
  pnm_image_t *pim = pnm_image_read(filename);
  float_image_t *fim = float_image_from_pnm_image(pim, NULL, NULL, FALSE);
  int c;
  for (c = 0; c < fim->sz[0]; c++) {
    float_image_apply_gamma(fim, c, gamma, bias);
  }
  pnm_image_free(pim);
  return fim;
}

void float_pnm_image_write(char *filename, float_image_t *fim, double gamma, double bias)
{
  int nc = fim->sz[0];
  assert((nc == 1) || (nc == 3));
  float_image_t * gim = float_image_copy(fim);
  int c;
  for (c = 0; c < fim->sz[0]; c++) {
    float_image_apply_gamma(gim, c, 1.0/gamma, bias);
  }
  pnm_image_t *pim = float_image_to_pnm_image(gim, nc, NULL, NULL, NULL, PNM_FILE_MAX_MAXVAL,FALSE);
  float_image_free(gim);
  pnm_image_write(filename, pim, FALSE);
  pnm_image_free(pim);
}

float_image_t **float_pnm_image_list_read(char* nome[], int n, double gamma, double bias)
{
  float_image_t **fim;
  int luz;
  fim = (float_image_t **)malloc(n * sizeof(float_image_t *));
  for(luz = 0; luz < n; luz++){
    fprintf(stderr,  "  light %d = %s\n",luz, nome[luz]);
    fim[luz] = float_pnm_image_read(nome[luz], gamma, bias);
  }
  return fim;
}
