#ifndef float_pnm_image_io_H
#define float_pnm_image_io_H

#include "float_image.h"

#define VIEW_GAMMA 2.200 
#define VIEW_BIAS  0.010
/* Gamma and bias for viewing images on IBM-PC-like platforms. */

float_image_t *float_pnm_image_read(char *filename, double gamma, double bias);
/* Reads the PGM or PPM image file with the given{filename}, and converts it 
   to a float image with samples in [0_1]. Applies the gamma decoding with
   exponent {gamma} and offset {bias}. */

void float_pnm_image_write(char *filename, float_image_t *fim, double gamma, double bias);
/* Writes the image as a PGM or PPM image file, depending on the number of channels.
   Clips the given image samples to [0_1] and quantizes them with {PNM_FILE_MAX_MAXVAL}. 
   Applies the gamma encoding with decoding exponent {gamma} and offset {bias}. */

float_image_t **float_pnm_image_list_read(char* nome[], int n, double gamma, double bias);
/* Applies {float_pnm_image_read(nome[i],gamma,bias)} for {i} in {0..n-1} and
  returns an array of pointers to the resulting float images. */

#endif
