/* See i2.h */
/* Last edited on 2007-01-04 04:00:19 by stolfi */

#include <i2.h>

#include <jsrandom.h>
#include <affirm.h>
#include <vec.h>

#include <math.h>
#include <stdio.h>

#define N 2

void i2_zero (i2_t *r)
  { r->c[0] = 0;
    r->c[1] = 0;
  }

void i2_all (int x, i2_t *r)
  { r->c[0] = x;
    r->c[1] = x;
  }

void i2_axis (int i, i2_t *r)
  { affirm((i >= 0) && (i < N), "i2_axis: bad index");
    r->c[0] = 0;
    r->c[1] = 0;
    r->c[i] = 1;
  }

void i2_add (i2_t *a, i2_t *b, i2_t *r)
  { r->c[0] = a->c[0] + b->c[0];
    r->c[1] = a->c[1] + b->c[1];
  }

void i2_sub (i2_t *a, i2_t *b, i2_t *r)
  { r->c[0] = a->c[0] - b->c[0];
    r->c[1] = a->c[1] - b->c[1];
  }

void i2_neg (i2_t *a, i2_t *r)
  { r->c[0] = - a->c[0];
    r->c[1] = - a->c[1];
  }

int i2_L_inf_norm (i2_t *a)
  { int d = 0;
    int a0 = abs(a->c[0]);
    int a1 = abs(a->c[1]);
    if (a0 > d) d = a0;
    if (a1 > d) d = a1;
    return d;
  }

int i2_L_inf_dist (i2_t *a, i2_t *b)
  { int d = 0;
    int d0 = fabs(a->c[0] - b->c[0]);
    int d1 = fabs(a->c[1] - b->c[1]);
    if (d0 > d) d = d0;
    if (d1 > d) d = d1;
    return (d);
  }

void i2_print (FILE *f, i2_t *a)
  { i2_gen_print(f, a, NULL, NULL, NULL, NULL); }

void i2_gen_print (FILE *f, i2_t *a, char *fmt, char *lp, char *sep, char *rp)
  { int i;
    if (fmt == NULL) { fmt = "%d"; }
    if (lp == NULL) { lp = "("; }
    if (sep == NULL) { sep = " "; }
    if (rp == NULL) { rp = ")"; }
    fputs(lp, f);
    for (i = 0; i < N; i++)
      { if (i > 0) { fputs(sep, f); }
        fprintf(f, fmt, a->c[i]);
      }
    fputs(rp, f);
  }

vec_typeimpl(i2_vec_t,i2_vec,i2_t);
