/* See jspnm_image.h */
/* Last edited on 2006-12-17 08:14:39 by stolfi */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>

#include <affirm.h>
#include <jsfile.h>
#include <jspnm.h>
#include <jspnm_image.h>

pnm_image_t *pnm_image_new(int cols, int rows, int chns)
  { /* Allocate header: */
    pnm_image_t *img = pnm_image_new_header(cols, rows, chns);
    /* Allocate pixels: */
    if ((cols != 0) && (rows != 0))
      { img->smp = pnm_image_alloc_pixel_array(cols, rows, chns); }
    return(img);
  }
  
void pnm_image_free(pnm_image_t *img)
  { if (img == NULL) return;
    if (img->smp != NULL) 
      { pnm_image_free_pixel_array(img->smp, img->cols, img->rows, img->chns); }
    free(img);
  }

pnm_image_t *pnm_image_new_header(int cols, int rows, int chns)
  { /* Allocate header: */
    pnm_image_t *img = (pnm_image_t *)pnm_malloc(sizeof(pnm_image_t));
    assert(img != NULL);
    /* Initialize fields: */
    img->cols = cols;
    img->rows = rows;
    img->chns = chns;
    /* Leave sample arrays as NULL: */
    img->smp = (pnm_sample_t**)NULL;
    return(img);
  }
  
pnm_sample_t** pnm_image_alloc_pixel_array(int cols, int rows, int chns)
  { int row;
    pnm_sample_t **smp = (pnm_sample_t **)pnm_malloc(rows*sizeof(pnm_sample_t *));
    for (row = 0; row < rows; row++)
      { smp[row] = pnm_image_alloc_pixel_row(cols, chns); }
    return smp;
  }
  
void pnm_image_free_pixel_array(pnm_sample_t **smp, int cols, int rows, int chns)
  { int row;
    if (smp == NULL) { return; }
    for (row = 0; row < rows; row++) 
      { pnm_image_free_pixel_row(smp[row], cols, chns); }
    free(smp);
  }

pnm_sample_t* pnm_image_alloc_pixel_row(int cols, int chns)
  { if (cols == 0)
      { return (pnm_sample_t *)NULL; }
    else
      { return (pnm_sample_t *)pnm_malloc(cols*chns*sizeof(pnm_sample_t)); }
  }
  
void pnm_image_free_pixel_row(pnm_sample_t *row, int cols, int chns)
  { 
    if (row != NULL) { free(row); }
  }

pnm_sample_t pnm_image_get_sample(pnm_image_t *im, int c, int x, int y)
  { if ((c < 0) || (c >= im->chns)) { return 0; }
    if ((x < 0) || (x >= im->cols)) { return 0; }
    if ((y < 0) || (y >= im->rows)) { return 0; }
    return im->smp[y][x*im->chns + c];
  }

void pnm_image_set_sample(pnm_image_t *im, int c, int x, int y, pnm_sample_t pv)
  { if ((c < 0) || (c >= im->chns)) { pnm_error("invalid channel"); }
    if ((x < 0) || (x >= im->cols)) { pnm_error("invalid column"); }
    if ((y < 0) || (y >= im->rows)) { pnm_error("invalid row"); }
    if (pv > im->maxval) { pnm_error("invalid sample value"); }
    im->smp[y][x*im->chns + c] = pv;
  }

pnm_image_t *pnm_image_read(char *name)
  { FILE *rd = open_read(name, FALSE);
    pnm_image_t *img = pnm_image_fread(rd);
    if (rd != stdin) { fclose(rd); }
    return img;
  }

pnm_image_t *pnm_image_fread(FILE *rd)
  { /* We cannot rely on {pnm_readpnm} because PBMPLUS has different pixel layout. */
    /* Read file header: */
    int cols, rows, chns;
    pnm_sample_t maxval;
    bool_t raw, bits;
    pnm_format_t format;
    pnm_read_header(rd, &cols, &rows, &chns, &maxval, &raw, &bits, &format);
    /* Allocate image and set maxval: */
    pnm_image_t *img = pnm_image_new(cols, rows, chns);
    img->maxval = maxval;
    /* Read pixels: */
    int row;
    for (row = 0; row < rows; row++)
      { pnm_read_pixels(rd, img->smp[row], cols, chns, maxval, raw, bits); }
    return(img);
  }
  
void pnm_image_write(char *name, pnm_image_t *img, bool_t forceplain)
  { FILE *wr = open_write(name, FALSE);
    pnm_image_fwrite(wr, img, forceplain);
    if (wr != stdout) { fclose(wr); }
  }
    
void pnm_image_fwrite(FILE *wr, pnm_image_t *img, bool_t forceplain)
  { /* We cannot rely on {pnm_writepnm} because PBMPLUS has different pixel layout. */
    pnm_format_t format;
    bool_t raw;
    bool_t bits; 
    pnm_choose_output_format(img->maxval, img->chns, forceplain, &format, &raw, &bits);
    pnm_write_header(wr, img->cols, img->rows, img->maxval, format);
    int row;
    for (row = 0; row < img->rows; row++)
      { pnm_write_pixels(wr, img->smp[row], img->cols, img->chns, img->maxval, raw, bits); }
    fflush(wr);
  }

