/* r6x6.h --- 4x4 matrices and operations on them */
/* Last edited on 2007-10-28 11:27:23 by stolfi */

#ifndef r6x6_H
#define r6x6_H

#include <stdio.h>
#include <r6.h>

typedef struct { double c[6][6]; } r6x6_t;

/* STANDARD OPERATIONS */

void r6x6_zero(r6x6_t *M);
  /* Stores in {M} the null matrix. */

void r6x6_ident(r6x6_t *M);
  /* Stores in {M} the identity matrix. */

void r6x6_transp (r6x6_t *A, r6x6_t *M);
  /* Sets {M} to the transpose {A^t} of matrix {A} */

void r6x6_map_row (r6_t *x, r6x6_t *A, r6_t *r);
  /* Sets {r} to the product of row vector {x} by matrix {A} */

void r6x6_map_col (r6x6_t *A, r6_t *x, r6_t *r);
  /* Sets {r} to the product of matrix {A} by column vector {x} */

void r6x6_mul (r6x6_t *A, r6x6_t *B, r6x6_t *M);
  /* Sets {M} to the product of matrices {A} and {B} */

void r6x6_mul_tr (r6x6_t *A, r6x6_t *B, r6x6_t *M);
  /* Computes the matrix product {M = A * B^t}. (In other words, sets
    {M[i,j]} to the dot product of row {i} of {A} and row {j} of {B}.) */

double r6x6_det (r6x6_t *A);
  /* Returns the determinant of matrix {A} */

void r6x6_adj (r6x6_t *A, r6x6_t *M);
  /* Sets {M} to the adjoint of matrix {A} */

void r6x6_inv (r6x6_t *A, r6x6_t *M);
  /* Sets {M} to the inverse of matrix {A} */

bool_t r6x6_is_unif_scaling(r6x6_t *M, double s);
  /* TRUE iff {M} is a diagonal matrix with all diagonal
    elements equal to {s}. */

void r6x6_print (FILE *f, r6x6_t *A);
  /* Prints matrix {A} to file {f}, with default format. */

void r6x6_gen_print
  ( FILE *f, r6x6_t *A,
    char *fmt, 
    char *olp, char *osep, char *orp, /* Outer delimiters. */
    char *ilp, char *isep, char *irp  /* Inner delimiters. */
  );
  /* Prints matrix {A} to file {f}, using {fmt} for each element.
    The matrix is bounded by {olp} and {orp}, and rows are separated
    by {osep}.  Each row is bounded by {ilp} and {irp}, and elements
    are separated by {isep}. Defaults are provided for any of these
    strings which are NULL. */

#endif

