/* See vec.h */
/* Last edited on 2008-03-29 14:33:12 by stolfi */

#include <vec.h>
#include <stdlib.h>
#include <stdint.h>
#include <affirm.h>

void *vec_alloc(uint32_t ne, size_t esz)
  { void *e = (ne == 0 ? NULL : malloc(ne*esz));
    affirm((ne == 0) || (e != NULL), "out of mem");
    return e;
  }

void vec_expand(uint32_t *nep, void **ep, uint32_t index, size_t esz)
  { if (index >= (*nep))
      { int ne = (*nep) + index + 1;
        if ((*nep) == 0) { affirm((*ep) == NULL, "bad elem pointer"); } 
        (*ep) = realloc((*ep), ne*esz);
        affirm((*ep) != NULL, "out of mem");
        (*nep) = ne;
      }
  }

void vec_trim(uint32_t *nep, void **ep, uint32_t ne, size_t esz)
  { if (ne != (*nep))
      { if (ne == 0) 
          { free((*ep)); (*ep) = NULL; }
        else
          { (*ep) = realloc((*ep), ne*esz);
            affirm((*ep) != NULL, "out of mem");
          }
        (*nep) = ne;
      }
  }

/* SOME USEFUL TYPED VECTORS */

vec_typeimpl(int_vec_t,    int_vec,    int);
vec_typeimpl(uint_vec_t,   uint_vec,   unsigned int);
vec_typeimpl(char_vec_t,   char_vec,   char);
vec_typeimpl(bool_vec_t,   bool_vec,   bool_t);
vec_typeimpl(float_vec_t,  float_vec,  float);
vec_typeimpl(double_vec_t, double_vec, double);
vec_typeimpl(ref_vec_t,    ref_vec,    void*);
vec_typeimpl(string_vec_t, string_vec, char*);


vec_typeimpl(int8_vec_t,    int8_vec,   int8_t);
vec_typeimpl(int16_vec_t,   int16_vec,  int16_t);
vec_typeimpl(int32_vec_t,   int32_vec,  int32_t);
vec_typeimpl(int64_vec_t,   int64_vec,  int64_t);
vec_typeimpl(uint8_vec_t,   uint8_vec,  uint8_t);
vec_typeimpl(uint16_vec_t,  uint16_vec, uint16_t);
vec_typeimpl(uint32_vec_t,  uint32_vec, uint32_t);
vec_typeimpl(uint64_vec_t,  uint64_vec, uint64_t);
