#include <Graph.h>

Vertice *novoVertice(int indice,int x,int y,Vizinho *vizinho,Vizinho *vizinhoD,Vertice *azul)
{
	Vertice *novo=malloc(sizeof(Vertice));
	novo->indice=indice;
	novo->x=x;
	novo->y=y;
	novo->vizinho=vizinho;
	novo->vizinhoD=vizinhoD;
	novo->azul=azul;
	novo->prox=NULL;
	return novo;
}

Vizinho *novoVizinho(Vertice *v)
{
	Vizinho *novo=malloc(sizeof(Vizinho));
	novo->vizinhos=v;
	novo->prox=NULL;
	return novo;
}

Grafo insere_Pixels(Grafo grafo,Vertice *v)
{
	if (grafo.ini==NULL)
	{
		grafo.ini=v;
		grafo.fim=v;
	}
	else
	{
		grafo.fim->prox=v;
		grafo.fim=v;
	}
	return grafo;
}

Grafo gera_lista_Pixels(Grafo grafo,float_image_t *img,int *indice)
{
	int i,j;
	Vertice *pixel=NULL;
	for (i=0;i<img->sz[1];i++)
		for (j=0;j<img->sz[2];j++)
		{
			indice++;
			pixel=novoVertice(indice,i,j,NULL,NULL,NULL);
			grafo=insere_Pixels(grafo,pixel);
		}
	return grafo;
}

Vertice *buscaVertice(Vertice *ini,int x,int y)
{
	Vertice *aux=ini;
	while ((aux!=NULL)&&(aux->x!=x)&&(aux->y!=y))
		aux=aux->prox;
	return aux;
}

Vertice *insereVizinho(Vertice *v,Vertice *vizinho)
{
	Vizinho *novo=novoVizinho(vizinho);
	if (v->vizinho==NULL)
		v->vizinho=novo;
	else
	{
		Vizinho *aux=v->vizinho;
		while (aux->prox!=NULL)
			aux=aux->prox;
		aux->prox=novo;
	}
	return v;
}

Vertice *insereVizinhoD(Vertice *v,Vertice *vizinho)
{
	Vizinho *novo=novoVizinho(vizinho);
	if (v->vizinhoD==NULL)
		v->vizinhoD=novo;
	else
	{
		Vizinho *aux=v->vizinhoD;
		while (aux->prox!=NULL)
			aux=aux->prox;
		aux->prox=novo;
	}
	return v;
}



Grafo gera_Rede_Nivel_K(Grafo grafo,float_image_t *img,int indice,int diagonal)
{
	int i,j;
	Vertice *v=grafo.ini;
	Vertice *vizinho;
	for (i=0;i<img->sz[1];i++)
		for (j=0;j<img->sz[2];j++)
		{
			vizinho=buscaVertice(grafo.ini,i+1,j);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice(grafo.ini,i-1,j);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice(grafo.ini,i,j+1);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			vizinho=buscaVertice(grafo.ini,i,j-1);
			if (vizinho!=NULL)
				v=insereVizinho(v,vizinho);
			if (diagonal==1)
			{
				vizinho=buscaVertice(grafo.ini,i+1,j-1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice(grafo.ini,i+1,j+1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice(grafo.ini,i-1,j-1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
				vizinho=buscaVertice(grafo.ini,i-1,j+1);
				if (vizinho!=NULL)
					v=insereVizinhoD(v,vizinho);
			}
			v=v->prox;
		}
	return grafo;
}

Grafo unirGrafos(Grafo grafoA,Grafo grafoB)
{
	grafoA.fim->prox=grafoB.ini;
	grafoA.fim=grafoB.fim;
	return grafoA;
}

Vertice *buscaIndice(Vertice *v, int indice)
{
	Vertice *aux=v;
	while ((aux!=NULL)&&(aux->indice!=indice))
		aux=aux->prox;
	return aux;
}

void insereAzul(Vertice *v,int indice)
{
	Vertice *ant=NULL;
	ant=buscaIndice(v,indice);
	if (ant!=NULL)
		ant->azul=v;
}

Grafo ligarNiveis(Grafo grafo,int N,int grupo,int w,int h)
{
	Vertice *v=grafo.ini;
	int tam=w*h;
	int K=0,i=0,j;
	while (K<N)
	{
		while (i<=tam)
		{
			for (j=0;j<=grupo;j++)
			{
				insereAzul(v,(2*v->indice+i));
				insereAzul(v,(2*v->indice+i+w));
			}
			i++;
			v=v->prox;
		}
		tam=tam+grupo*tam;
		w=grupo*w;
		K++;
	}
	return grafo;
}

Grafo cloneGrafo(Grafo *grafo)
{
	Grafo newG;
	newG.ini=NULL;
	newG.fim=NULL;
	Vertice *aux=NULL;
	aux=grafo->ini;
	while (aux!=NULL)
	{
		newG=insere_Pixels(newG,novoVertice(aux->indice,aux->x,aux->y,aux->vizinho,aux->vizinhoD,aux->azul));
		aux=aux->prox;
	}
	return newG;
}

/*void inicializa(int d[],int p[],int maxIndice,int orig)
{
	int i;
	for (i=0;i<=maxIndice;i++)
	{
		d[i]=9999999999999999;
		p[i]=-1;
	}
	d[orig]=0;
}

void relaxa(int d[],int p[],Vertice *v1,Vertice *v2,int peso)
{
	if (d[v1->indice]>(d[v2->indice] + peso))
	{
		d[v1->indice]=d[v2->indice] + peso;
		p[v1->indice]=v2->indice;
	}
}

void relaxaVizinhos(int d[],int p[],Vertice *v)
{
	Vizinho *aux=v->vizinho;
	while (aux!=NULL)
	{
		relaxa(d,v,aux->vizinhos,1);
		aux=aux->prox
	}
	relaxa(d,v,v->azul);
}

void Dijkstra(Grafo grafo,int maxIndice)
{
	inicializa(d,p,maxIndice,orig);
	Grafo g=clone(grafo);
	Grafo result;
	Vertice *aux=g.ini;
	while (aux!=NULL)
	{
		atual=extrai_minimo(G);
		result=insere_Pixels(result,atual);
		relaxaVizinhos(d,p,aux);
		aux=aux->prox;
	}
}*/
