#ifndef Graph
#define Graph

#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

#include <bool.h>             
#include <jsfile.h>           
#include <jspnm_image.h>      
#include <float_image.h>      
#include <float_pnm_image.h>  
#include <argparser.h> 

typedef struct vizinho {
	struct vertice *vizinhos;
	struct vizinho *prox;
}Vizinho;

typedef struct vertice {
	int indice;
	int x,y;
	Vizinho *vizinho;
	Vizinho *vizinhoD;
	struct vertice *azul;
	struct vertice *prox;
}Vertice;

typedef struct grafo {
	Vertice *ini;
	Vertice *fim;
}Grafo;

Vertice *novoVertice(int indice,int x,int y,Vizinho *vizinho,Vizinho *vizinhoD,Vertice *azul);
Vizinho *novoVizinho(Vertice *v);
Grafo insere_Pixels(Grafo grafo,Vertice *v);
Grafo gera_lista_Pixels(Grafo grafo,float_image_t *img,int *indice);
Vertice *buscaVertice(Vertice *ini,int x,int y);
Vertice *insereVizinho(Vertice *v,Vertice *vizinho);
Vertice *insereVizinhoD(Vertice *v,Vertice *vizinho);
Grafo gera_Rede_Nivel_K(Grafo grafo,float_image_t *img,int indice,int diagonal);
Grafo unirGrafos(Grafo grafoA,Grafo grafoB);
Vertice *buscaIndice(Vertice *v, int indice);
void insereAzul(Vertice *v,int indice);
Grafo ligarNiveis(Grafo grafo,int N,int grupo,int w,int h);
Grafo cloneGrafo(Grafo *grafo);


#endif
