#ifndef animacao
#define animacao

#define _GNU_SOURCE
#include <stdio.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>


//#include <List.h>
#include <candidatos.h>

typedef struct Plotter_ Plotter_t;

Plotter_t *openPlotter(char *dir, char *subdir, int online);
// Abre uma janela (online = 1) ou diretorio (online = 0) para plotagens.
// Se for diretório, os plots serão gravados no diretório "{dir}/{subdir}/Animacao"

void closePlotter(Plotter_t *plotter);
// Fecha janela/diretorio para plotagens.

void beginPlot(Plotter_t *plotter, int nBoxes, int iteracao);
// Inicio de um novo plot na janela/diretorio {plot}.
// Se for diretório, o nome do arquivo é ???

void endPlot(Plotter_t *plotter);
// Finaliza o plot corrente.

void drawQueue(Plotter_t *plotter, candidato_t *prim, QFILA_t qual, int res_max, float dAstLo, float dAstHi);
// Desenha os intervalos da fila {qual} que começa em {prim}, e o intervalo 
// de corte {dAstLo,dAstHi}.

// Internas
void makeDir(char *dir, char *subdir, char *subsubdir);
#endif
